/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.http.server;

import com.hexagonkt.helpers.Jvm;
import com.hexagonkt.http.Protocol;
import com.hexagonkt.http.server.Router;
import com.hexagonkt.http.server.Server;
import com.hexagonkt.http.server.ServerPort;
import com.hexagonkt.http.server.ServerSettings;
import com.hexagonkt.injection.InjectionManager;
import com.hexagonkt.logging.Logger;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.net.InetAddress;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0001.B4\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u000bB!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010 \u001a\u00020\bH\u00c2\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J'\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%H\u0002J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u001aH\u00d6\u0001J\u0006\u0010*\u001a\u00020\tJ\u0006\u0010+\u001a\u00020'J\u0006\u0010,\u001a\u00020\tJ\t\u0010-\u001a\u00020\u0016H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006/"}, d2={"Lcom/hexagonkt/http/server/Server;", "", "adapter", "Lcom/hexagonkt/http/server/ServerPort;", "settings", "Lcom/hexagonkt/http/server/ServerSettings;", "block", "Lkotlin/Function1;", "Lcom/hexagonkt/http/server/Router;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/hexagonkt/http/server/ServerPort;Lcom/hexagonkt/http/server/ServerSettings;Lkotlin/jvm/functions/Function1;)V", "router", "(Lcom/hexagonkt/http/server/ServerPort;Lcom/hexagonkt/http/server/Router;Lcom/hexagonkt/http/server/ServerSettings;)V", "contextRouter", "getContextRouter", "()Lcom/hexagonkt/http/server/Router;", "contextRouter$delegate", "Lkotlin/Lazy;", "log", "Lcom/hexagonkt/logging/Logger;", "portName", "", "getPortName", "()Ljava/lang/String;", "runtimePort", "", "getRuntimePort", "()I", "getSettings", "()Lcom/hexagonkt/http/server/ServerSettings;", "component1", "component2", "component3", "copy", "createBanner", "startUpTimestamp", "", "equals", "", "other", "hashCode", "start", "started", "stop", "toString", "Companion", "port_http_server"})
public final class Server {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerPort adapter;
    @NotNull
    private final Router router;
    @NotNull
    private final ServerSettings settings;
    @NotNull
    private final Logger log;
    @NotNull
    private final Lazy contextRouter$delegate;
    @NotNull
    private final String portName;
    @NotNull
    private static final String banner = "\u001b[36m          _________\n\u001b[36m         /         \\\n\u001b[36m        /   ____   /\n\u001b[36m       /   /   /  /\n\u001b[36m      /   /   /__/\u001b[34m   /\\\u001b[1m    H E X A G O N\u001b[0m\n\u001b[36m     /   /\u001b[34m          /  \\\u001b[39m        ___\n\u001b[36m     \\  /\u001b[34m   ___    /   /\n\u001b[36m      \\/\u001b[34m   /  /   /   /\u001b[36m    T O O L K I T\u001b[0m\n\u001b[34m          /  /___/   /\n\u001b[34m         /          /\n\u001b[34m         \\_________/       https://hexagonkt.com/port_http_server\n\u001b[0m";

    public Server(@NotNull ServerPort adapter, @NotNull Router router, @NotNull ServerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.adapter = adapter;
        this.router = router;
        this.settings = settings;
        this.log = new Logger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this.contextRouter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Router>(this){
            final /* synthetic */ Server this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Router invoke() {
                CharSequence charSequence = this.this$0.getSettings().getContextPath();
                boolean bl = false;
                return charSequence.length() == 0 ? Server.access$getRouter$p(this.this$0) : new Router((Function1<? super Router, Unit>)((Function1)new Function1<Router, Unit>(this.this$0){
                    final /* synthetic */ Server this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Router $this$$receiver) {
                        Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                        $this$$receiver.path(this.this$0.getSettings().getContextPath(), Server.access$getRouter$p(this.this$0));
                    }
                }));
            }
        }));
        String string = this.adapter.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"adapter.javaClass.simpleName");
        this.portName = string;
    }

    public /* synthetic */ Server(ServerPort serverPort, Router router, ServerSettings serverSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            InjectionManager this_$iv = InjectionManager.INSTANCE;
            boolean $i$f$inject = false;
            serverPort = (ServerPort)this_$iv.inject(Reflection.getOrCreateKotlinClass(ServerPort.class));
        }
        if ((n & 4) != 0) {
            serverSettings = new ServerSettings(null, 0, null, null, null, null, null, null, 255, null);
        }
        this(serverPort, router, serverSettings);
    }

    @NotNull
    public final ServerSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final Router getContextRouter() {
        Lazy lazy = this.contextRouter$delegate;
        boolean bl = false;
        return (Router)lazy.getValue();
    }

    public Server(@NotNull ServerPort adapter, @NotNull ServerSettings settings, @NotNull Function1<? super Router, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this(adapter, new Router(block), settings);
    }

    public /* synthetic */ Server(ServerPort serverPort, ServerSettings serverSettings, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            InjectionManager this_$iv = InjectionManager.INSTANCE;
            boolean $i$f$inject = false;
            serverPort = (ServerPort)this_$iv.inject(Reflection.getOrCreateKotlinClass(ServerPort.class));
        }
        if ((n & 2) != 0) {
            InjectionManager this_$iv = InjectionManager.INSTANCE;
            boolean $i$f$injectOrNull = false;
            ServerSettings serverSettings2 = (ServerSettings)this_$iv.injectOrNull(Reflection.getOrCreateKotlinClass(ServerSettings.class));
            serverSettings = serverSettings2 == null ? new ServerSettings(null, 0, null, null, null, null, null, null, 255, null) : serverSettings2;
        }
        this(serverPort, serverSettings, (Function1<? super Router, Unit>)function1);
    }

    public final int getRuntimePort() {
        if (!this.started()) {
            String string = "Server is not running";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.adapter.runtimePort();
    }

    @NotNull
    public final String getPortName() {
        return this.portName;
    }

    public final boolean started() {
        return this.adapter.started();
    }

    public final void start() {
        long startTimestamp = System.nanoTime();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Server.start$lambda-0(this), "shutdown-" + this.settings.getBindAddress().getHostName() + '-' + this.settings.getBindPort()));
        this.adapter.startup(this);
        this.log.info((Function0)new Function0<Object>(this, startTimestamp){
            final /* synthetic */ Server this$0;
            final /* synthetic */ long $startTimestamp;
            {
                this.this$0 = $receiver;
                this.$startTimestamp = $startTimestamp;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"Server started\n", (Object)Server.access$createBanner(this.this$0, System.nanoTime() - this.$startTimestamp));
            }
        });
    }

    public final void stop() {
        this.adapter.shutdown();
        this.log.info((Function0)stop.1.INSTANCE);
    }

    private final String createBanner(long startUpTimestamp) {
        String string;
        MemoryUsage heap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        String string2 = "%,d";
        Object object = new Object[]{heap.getInit() / (long)1024};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
        String jvmMemory = string3;
        object = "%,d";
        Object object2 = new Object[]{heap.getUsed() / (long)1024};
        boolean bl2 = false;
        String string4 = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(this, *args)");
        String usedMemory = string4;
        object2 = "%01.3f";
        Object object3 = new Object[]{(double)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0};
        boolean bl3 = false;
        String string5 = String.format((String)object2, Arrays.copyOf(object3, ((Object[])object3).length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(this, *args)");
        String bootTime = string5;
        object3 = "%,.0f";
        Object[] objectArray = new Object[]{(double)startUpTimestamp / 1000000.0};
        boolean bl4 = false;
        String string6 = String.format((String)object3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(this, *args)");
        String startUpTime = string6;
        InetAddress bindAddress = this.settings.getBindAddress();
        Protocol protocol = this.settings.getProtocol();
        String hostName = bindAddress.isAnyLocalAddress() ? Jvm.INSTANCE.getIp() : bindAddress.getCanonicalHostName();
        String scheme2 = protocol == Protocol.HTTP ? "http" : "https";
        String binding = scheme2 + "://" + hostName + ':' + this.getRuntimePort();
        String serverAdapterValue = "\u001b[1m\u001b[36m" + this.portName + "\u001b[0m";
        String protocols = CollectionsKt.joinToString$default((Iterable)this.adapter.supportedProtocols(), (CharSequence)"\u001b[0m, \u001b[36m", (CharSequence)"\u001b[36m", (CharSequence)"\u001b[0m", (int)0, null, null, (int)56, null);
        String features = CollectionsKt.joinToString$default((Iterable)this.adapter.supportedFeatures(), (CharSequence)"\u001b[0m, \u001b[36m", (CharSequence)"\u001b[36m", (CharSequence)"\u001b[0m", (int)0, null, null, (int)56, null);
        String options = CollectionsKt.joinToString$default((Iterable)this.adapter.supportedOptions(), (CharSequence)"\u001b[0m, \u001b[36m", (CharSequence)"\u001b[36m", (CharSequence)"\u001b[0m", (int)0, null, null, (int)56, null);
        String hostnameValue = "\u001b[34m" + Jvm.INSTANCE.getHostname() + "\u001b[0m";
        String cpuCountValue = "\u001b[34m" + Jvm.INSTANCE.getCpuCount() + "\u001b[0m";
        String jvmMemoryValue = "\u001b[34m" + jvmMemory + "\u001b[0m";
        String javaVersionValue = "\u001b[1m\u001b[34mJava " + Jvm.INSTANCE.getVersion() + "\u001b[0m [\u001b[34m" + Jvm.INSTANCE.getName() + "\u001b[0m]";
        String localeValue = "\u001b[34m" + Jvm.INSTANCE.getLocale() + "\u001b[0m";
        String timezoneValue = "\u001b[34m" + Jvm.INSTANCE.getTimezone() + "\u001b[0m";
        String charsetValue = "\u001b[34m" + Jvm.INSTANCE.getCharset() + "\u001b[0m";
        String bootTimeValue = "\u001b[1m\u001b[35m" + bootTime + " s\u001b[0m";
        String startUpTimeValue = "\u001b[1m\u001b[35m" + startUpTime + " ms\u001b[0m";
        String usedMemoryValue = "\u001b[1m\u001b[35m" + usedMemory + " KB\u001b[0m";
        String bindingValue = "\u001b[34m\u001b[4m" + binding + "\u001b[0m";
        String information = StringsKt.trimIndent((String)("\n\n            Server Adapter: " + serverAdapterValue + " (" + protocols + ")\n            Supported Features: " + features + "\n            Configuration Options: " + options + "\n\n            Running in '" + hostnameValue + "' with " + cpuCountValue + " CPUs " + jvmMemoryValue + " KB\n            Using " + javaVersionValue + "\n            Locale: " + localeValue + " Timezone: " + timezoneValue + " Charset: " + charsetValue + "\n\n            Started in " + bootTimeValue + " (server: " + startUpTimeValue + ") using " + usedMemoryValue + "\n            Served at " + bindingValue + (protocol == Protocol.HTTP2 ? " (HTTP/2)" : "") + "\n        "));
        String string7 = this.settings.getBanner();
        if (string7 == null) {
            string = null;
        } else {
            String string8 = string7;
            boolean bl5 = false;
            boolean bl6 = false;
            String it = string8;
            boolean bl7 = false;
            string = Intrinsics.stringPlus((String)it, (Object)"\n");
        }
        String string9 = string;
        String banner = Intrinsics.stringPlus((String)(string9 == null ? Server.banner : string9), (Object)information);
        return com.hexagonkt.helpers.StringsKt.prependIndent$default((String)banner, (int)0, null, (int)3, null);
    }

    private final ServerPort component1() {
        return this.adapter;
    }

    private final Router component2() {
        return this.router;
    }

    @NotNull
    public final ServerSettings component3() {
        return this.settings;
    }

    @NotNull
    public final Server copy(@NotNull ServerPort adapter, @NotNull Router router, @NotNull ServerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new Server(adapter, router, settings);
    }

    public static /* synthetic */ Server copy$default(Server server, ServerPort serverPort, Router router, ServerSettings serverSettings, int n, Object object) {
        if ((n & 1) != 0) {
            serverPort = server.adapter;
        }
        if ((n & 2) != 0) {
            router = server.router;
        }
        if ((n & 4) != 0) {
            serverSettings = server.settings;
        }
        return server.copy(serverPort, router, serverSettings);
    }

    @NotNull
    public String toString() {
        return "Server(adapter=" + this.adapter + ", router=" + this.router + ", settings=" + this.settings + ')';
    }

    public int hashCode() {
        int result = this.adapter.hashCode();
        result = result * 31 + this.router.hashCode();
        result = result * 31 + this.settings.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Server)) {
            return false;
        }
        Server server = (Server)other;
        if (!Intrinsics.areEqual((Object)this.adapter, (Object)server.adapter)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.router, (Object)server.router)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.settings, (Object)server.settings);
    }

    private static final void start$lambda-0(Server this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.started()) {
            this$0.adapter.shutdown();
        }
    }

    public static final /* synthetic */ String access$createBanner(Server $this, long startUpTimestamp) {
        return $this.createBanner(startUpTimestamp);
    }

    public static final /* synthetic */ Router access$getRouter$p(Server $this) {
        return $this.router;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/hexagonkt/http/server/Server$Companion;", "", "()V", "banner", "", "getBanner", "()Ljava/lang/String;", "port_http_server"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getBanner() {
            return banner;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

