/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.serialization.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\b\u000b\f\r\u000e\u000f\u0010\u0011\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0013"}, d2={"Lcom/hexagonkt/serialization/jackson/JacksonHelper;", "", "()V", "createObjectMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "mapperFactory", "Lcom/fasterxml/jackson/core/JsonFactory;", "mapNode", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "nodeToCollection", "ByteBufferDeserializer", "ByteBufferSerializer", "ClosedRangeDeserializer", "ClosedRangeSerializer", "FloatDeserializer", "FloatSerializer", "InetAddressDeserializer", "InetAddressSerializer", "serialization_jackson"})
public final class JacksonHelper {
    @NotNull
    public static final JacksonHelper INSTANCE = new JacksonHelper();

    private JacksonHelper() {
    }

    @NotNull
    public final JsonMapper createObjectMapper(@NotNull JsonFactory mapperFactory) {
        Intrinsics.checkNotNullParameter((Object)mapperFactory, (String)"mapperFactory");
        ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)mapperFactory).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true)).configure(JsonParser.Feature.ALLOW_COMMENTS, true)).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true)).configure(JsonReadFeature.ALLOW_TRAILING_COMMA, true).configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, false)).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true)).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, false)).addModule((Module)new JavaTimeModule())).addModule((Module)new SimpleModule().addSerializer(ByteBuffer.class, (JsonSerializer)ByteBufferSerializer.INSTANCE).addDeserializer(ByteBuffer.class, (JsonDeserializer)ByteBufferDeserializer.INSTANCE).addSerializer(ClosedRange.class, (JsonSerializer)ClosedRangeSerializer.INSTANCE).addDeserializer(ClosedRange.class, (JsonDeserializer)new ClosedRangeDeserializer(null, 1, null)).addSerializer(Float.TYPE, (JsonSerializer)FloatSerializer.INSTANCE).addDeserializer(Float.TYPE, (JsonDeserializer)FloatDeserializer.INSTANCE).addSerializer(InetAddress.class, (JsonSerializer)InetAddressSerializer.INSTANCE).addDeserializer(InetAddress.class, (JsonDeserializer)InetAddressDeserializer.INSTANCE))).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"builder(mapperFactory)\n \u2026   )\n            .build()");
        return (JsonMapper)objectMapper;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object nodeToCollection(@NotNull JsonNode node) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        JsonNode jsonNode = node;
        if (jsonNode instanceof ArrayNode) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.toList((Iterable)((Iterable)node));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonNode jsonNode2 = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(INSTANCE.nodeToCollection((JsonNode)it));
            }
            object = (List)destination$iv$iv;
        } else if (jsonNode instanceof ObjectNode) {
            void var3_4;
            Map map = MapsKt.emptyMap();
            Iterator iterator = node.fields();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"node.fields()");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Map.Entry f = (Map.Entry)iterator2.next();
                Object k = f.getKey();
                Object v = f.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"f.value");
                map = MapsKt.plus((Map)map, (Pair)TuplesKt.to(k, (Object)this.nodeToCollection((JsonNode)v)));
            }
            object = var3_4;
        } else if (jsonNode instanceof TextNode) {
            object = node.textValue();
        } else if (jsonNode instanceof BigIntegerNode) {
            object = node.bigIntegerValue();
        } else if (jsonNode instanceof BooleanNode) {
            object = node.booleanValue();
        } else if (jsonNode instanceof DoubleNode) {
            object = node.doubleValue();
        } else if (jsonNode instanceof FloatNode) {
            object = Float.valueOf(node.floatValue());
        } else if (jsonNode instanceof IntNode) {
            object = node.intValue();
        } else if (jsonNode instanceof LongNode) {
            object = node.longValue();
        } else if (jsonNode instanceof NullNode) {
            object = null;
        } else if (jsonNode instanceof BinaryNode) {
            object = node.binaryValue();
        } else {
            throw new IllegalStateException(("Unknown node type: " + Reflection.getOrCreateKotlinClass(node.getClass()).getQualifiedName()).toString());
        }
        return object;
    }

    @NotNull
    public final Object mapNode(@NotNull JsonNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object object = this.nodeToCollection(node);
        if (object == null) {
            throw new IllegalStateException("Parsed content is 'null'".toString());
        }
        return object;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/hexagonkt/serialization/jackson/JacksonHelper$InetAddressSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Ljava/net/InetAddress;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "serialization_jackson"})
    public static final class InetAddressSerializer
    extends JsonSerializer<InetAddress> {
        @NotNull
        public static final InetAddressSerializer INSTANCE = new InetAddressSerializer();

        private InetAddressSerializer() {
        }

        public void serialize(@NotNull InetAddress value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            gen.writeString(value.getHostAddress());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/hexagonkt/serialization/jackson/JacksonHelper$InetAddressDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Ljava/net/InetAddress;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "serialization_jackson"})
    public static final class InetAddressDeserializer
    extends JsonDeserializer<InetAddress> {
        @NotNull
        public static final InetAddressDeserializer INSTANCE = new InetAddressDeserializer();

        private InetAddressDeserializer() {
        }

        @NotNull
        public InetAddress deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            InetAddress inetAddress = InetAddress.getByName(p.getText());
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(p.text)");
            return inetAddress;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/hexagonkt/serialization/jackson/JacksonHelper$FloatSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "serialization_jackson"})
    public static final class FloatSerializer
    extends JsonSerializer<Float> {
        @NotNull
        public static final FloatSerializer INSTANCE = new FloatSerializer();

        private FloatSerializer() {
        }

        public void serialize(float value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            gen.writeNumber(new BigDecimal(String.valueOf(value)).doubleValue());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/hexagonkt/serialization/jackson/JacksonHelper$FloatDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)Ljava/lang/Float;", "serialization_jackson"})
    public static final class FloatDeserializer
    extends JsonDeserializer<Float> {
        @NotNull
        public static final FloatDeserializer INSTANCE = new FloatDeserializer();

        private FloatDeserializer() {
        }

        @NotNull
        public Float deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            return Float.valueOf(p.getFloatValue());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/hexagonkt/serialization/jackson/JacksonHelper$ByteBufferSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Ljava/nio/ByteBuffer;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "serialization_jackson"})
    public static final class ByteBufferSerializer
    extends JsonSerializer<ByteBuffer> {
        @NotNull
        public static final ByteBufferSerializer INSTANCE = new ByteBufferSerializer();

        private ByteBufferSerializer() {
        }

        public void serialize(@NotNull ByteBuffer value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            gen.writeString(Base64.getEncoder().encodeToString(value.array()));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/hexagonkt/serialization/jackson/JacksonHelper$ByteBufferDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Ljava/nio/ByteBuffer;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "serialization_jackson"})
    public static final class ByteBufferDeserializer
    extends JsonDeserializer<ByteBuffer> {
        @NotNull
        public static final ByteBufferDeserializer INSTANCE = new ByteBufferDeserializer();

        private ByteBufferDeserializer() {
        }

        @NotNull
        public ByteBuffer deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            ByteBuffer byteBuffer = ByteBuffer.wrap(Base64.getDecoder().decode(p.getText()));
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap (Base64.getDecoder ().decode (p.text))");
            return byteBuffer;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/hexagonkt/serialization/jackson/JacksonHelper$ClosedRangeSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lkotlin/ranges/ClosedRange;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "serialization_jackson"})
    public static final class ClosedRangeSerializer
    extends JsonSerializer<ClosedRange<?>> {
        @NotNull
        public static final ClosedRangeSerializer INSTANCE = new ClosedRangeSerializer();

        private ClosedRangeSerializer() {
        }

        public void serialize(@NotNull ClosedRange<?> value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            Comparable start = value.getStart();
            Comparable end = value.getEndInclusive();
            JsonSerializer valueSerializer = serializers.findValueSerializer(start.getClass());
            gen.writeStartObject();
            gen.writeFieldName("start");
            valueSerializer.serialize((Object)start, gen, serializers);
            gen.writeFieldName("endInclusive");
            valueSerializer.serialize((Object)end, gen, serializers);
            gen.writeEndObject();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u00020\u0003B\u0011\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/hexagonkt/serialization/jackson/JacksonHelper$ClosedRangeDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lkotlin/ranges/ClosedRange;", "Lcom/fasterxml/jackson/databind/deser/ContextualDeserializer;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "(Lcom/fasterxml/jackson/databind/JavaType;)V", "createContextual", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "property", "Lcom/fasterxml/jackson/databind/BeanProperty;", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "serialization_jackson"})
    public static final class ClosedRangeDeserializer
    extends JsonDeserializer<ClosedRange<?>>
    implements ContextualDeserializer {
        @Nullable
        private final JavaType type;

        public ClosedRangeDeserializer(@Nullable JavaType type) {
            this.type = type;
        }

        public /* synthetic */ ClosedRangeDeserializer(JavaType javaType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                javaType = null;
            }
            this(javaType);
        }

        @NotNull
        public JsonDeserializer<?> createContextual(@NotNull DeserializationContext ctxt, @NotNull BeanProperty property) {
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            return new ClosedRangeDeserializer(property.getType().containedType(0));
        }

        @NotNull
        public ClosedRange<?> deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            JsonToken token = p.getCurrentToken();
            if (!(token == JsonToken.START_OBJECT)) {
                boolean $i$a$-check-JacksonHelper$ClosedRangeDeserializer$deserialize$42 = false;
                String $i$a$-check-JacksonHelper$ClosedRangeDeserializer$deserialize$42 = token.name() + " should be: " + JsonToken.START_OBJECT.name();
                throw new IllegalStateException($i$a$-check-JacksonHelper$ClosedRangeDeserializer$deserialize$42.toString());
            }
            if (!Intrinsics.areEqual((Object)p.nextFieldName(), (Object)"start")) {
                boolean $i$a$-check-JacksonHelper$ClosedRangeDeserializer$deserialize$52 = false;
                String $i$a$-check-JacksonHelper$ClosedRangeDeserializer$deserialize$52 = "Ranges start with 'start' field";
                throw new IllegalStateException($i$a$-check-JacksonHelper$ClosedRangeDeserializer$deserialize$52.toString());
            }
            p.nextToken();
            Comparable start = (Comparable)ctxt.readValue(p, this.type);
            if (!Intrinsics.areEqual((Object)p.nextFieldName(), (Object)"endInclusive")) {
                boolean bl = false;
                String string = "Ranges end with 'endInclusive' field";
                throw new IllegalStateException(string.toString());
            }
            p.nextToken();
            Comparable end = (Comparable)ctxt.readValue(p, this.type);
            p.nextToken();
            return RangesKt.rangeTo((Comparable)start, (Comparable)end);
        }

        public ClosedRangeDeserializer() {
            this(null, 1, null);
        }
    }
}

