/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.serialization.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.hexagonkt.serialization.SerializationFormat;
import com.hexagonkt.serialization.jackson.JacksonHelper;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0018\u0010\u001b\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\r\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/hexagonkt/serialization/jackson/JacksonTextFormat;", "Lcom/hexagonkt/serialization/SerializationFormat;", "factoryGenerator", "Lkotlin/Function0;", "Lcom/fasterxml/jackson/core/JsonFactory;", "prettyPrint", "", "(Lkotlin/jvm/functions/Function0;Z)V", "mapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/json/JsonMapper;", "mapper$delegate", "Lkotlin/Lazy;", "textFormat", "getTextFormat", "()Z", "writer", "Lcom/fasterxml/jackson/databind/ObjectWriter;", "kotlin.jvm.PlatformType", "getWriter", "()Lcom/fasterxml/jackson/databind/ObjectWriter;", "writer$delegate", "parse", "", "input", "Ljava/io/InputStream;", "serialize", "", "instance", "", "output", "Ljava/io/OutputStream;", "serialization_jackson"})
public abstract class JacksonTextFormat
implements SerializationFormat {
    @NotNull
    private final Lazy mapper$delegate;
    private final boolean textFormat;
    @NotNull
    private final Lazy writer$delegate;

    public JacksonTextFormat(@NotNull Function0<? extends JsonFactory> factoryGenerator, boolean prettyPrint) {
        Intrinsics.checkNotNullParameter(factoryGenerator, (String)"factoryGenerator");
        this.mapper$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JsonMapper>(factoryGenerator){
            final /* synthetic */ Function0<JsonFactory> $factoryGenerator;
            {
                this.$factoryGenerator = $factoryGenerator;
                super(0);
            }

            @NotNull
            public final JsonMapper invoke() {
                return JacksonHelper.INSTANCE.createObjectMapper((JsonFactory)this.$factoryGenerator.invoke());
            }
        }));
        this.textFormat = true;
        this.writer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ObjectWriter>(prettyPrint, this){
            final /* synthetic */ boolean $prettyPrint;
            final /* synthetic */ JacksonTextFormat this$0;
            {
                this.$prettyPrint = $prettyPrint;
                this.this$0 = $receiver;
                super(0);
            }

            public final ObjectWriter invoke() {
                return this.$prettyPrint ? JacksonTextFormat.access$getMapper(this.this$0).writer((PrettyPrinter)new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE)) : JacksonTextFormat.access$getMapper(this.this$0).writer();
            }
        }));
    }

    public /* synthetic */ JacksonTextFormat(Function0 function0, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this((Function0<? extends JsonFactory>)function0, bl);
    }

    private final JsonMapper getMapper() {
        Lazy lazy = this.mapper$delegate;
        return (JsonMapper)lazy.getValue();
    }

    public boolean getTextFormat() {
        return this.textFormat;
    }

    private final ObjectWriter getWriter() {
        Lazy lazy = this.writer$delegate;
        return (ObjectWriter)lazy.getValue();
    }

    public void serialize(@NotNull Object instance, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.getWriter().writeValue(output, instance);
    }

    @NotNull
    public String serialize(@NotNull Object instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        String string = this.getWriter().writeValueAsString(instance);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.writeValueAsString(instance)");
        return string;
    }

    @NotNull
    public Object parse(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        JsonNode jsonNode = this.getMapper().readTree(input);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"mapper.readTree(input)");
        return JacksonHelper.INSTANCE.mapNode(jsonNode);
    }

    @NotNull
    public Object parse(@NotNull String input) {
        return SerializationFormat.DefaultImpls.parse((SerializationFormat)this, (String)input);
    }

    @NotNull
    public byte[] serializeBytes(@NotNull Object instance) {
        return SerializationFormat.DefaultImpls.serializeBytes((SerializationFormat)this, (Object)instance);
    }

    public JacksonTextFormat() {
        this(null, false, 3, null);
    }

    public static final /* synthetic */ JsonMapper access$getMapper(JacksonTextFormat $this) {
        return $this.getMapper();
    }
}

