/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.serialization.jackson.csv;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.hexagonkt.core.media.MediaType;
import com.hexagonkt.core.media.MediaTypesKt;
import com.hexagonkt.serialization.SerializationFormat;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/hexagonkt/serialization/jackson/csv/Csv;", "Lcom/hexagonkt/serialization/SerializationFormat;", "()V", "mapper", "Lcom/fasterxml/jackson/dataformat/csv/CsvMapper;", "mediaType", "Lcom/hexagonkt/core/media/MediaType;", "getMediaType", "()Lcom/hexagonkt/core/media/MediaType;", "reader", "Lcom/fasterxml/jackson/databind/ObjectReader;", "kotlin.jvm.PlatformType", "textFormat", "", "getTextFormat", "()Z", "parse", "", "input", "Ljava/io/InputStream;", "serialize", "", "instance", "output", "Ljava/io/OutputStream;", "serialization_jackson_csv"})
public final class Csv
implements SerializationFormat {
    @NotNull
    public static final Csv INSTANCE = new Csv();
    @NotNull
    private static final MediaType mediaType = MediaTypesKt.getTEXT_CSV();
    private static final boolean textFormat = true;
    @NotNull
    private static final CsvMapper mapper;
    private static final ObjectReader reader;

    private Csv() {
    }

    @NotNull
    public MediaType getMediaType() {
        return mediaType;
    }

    public boolean getTextFormat() {
        return textFormat;
    }

    public void serialize(@NotNull Object instance, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        mapper.writeValue(output, instance);
    }

    @NotNull
    public Object parse(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Object object = reader.readValue(input);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return object;
    }

    @NotNull
    public String serialize(@NotNull Object instance) {
        return SerializationFormat.DefaultImpls.serialize((SerializationFormat)this, (Object)instance);
    }

    @NotNull
    public Object parse(@NotNull String input) {
        return SerializationFormat.DefaultImpls.parse((SerializationFormat)this, (String)input);
    }

    @NotNull
    public byte[] serializeBytes(@NotNull Object instance) {
        return SerializationFormat.DefaultImpls.serializeBytes((SerializationFormat)this, (Object)instance);
    }

    static {
        CsvMapper csvMapper = new CsvMapper().configure(CsvGenerator.Feature.ALWAYS_QUOTE_EMPTY_STRINGS, false).configure(CsvParser.Feature.ALLOW_TRAILING_COMMA, false).configure(CsvParser.Feature.SKIP_EMPTY_LINES, true).configure(CsvParser.Feature.WRAP_AS_ARRAY, true);
        Intrinsics.checkNotNullExpressionValue((Object)csvMapper, (String)"configure(...)");
        mapper = csvMapper;
        reader = mapper.readerForListOf(Object.class);
    }
}

