/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.serialization.jackson.xml;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import com.hexagonkt.core.media.MediaType;
import com.hexagonkt.core.media.MediaTypesKt;
import com.hexagonkt.serialization.SerializationFormat;
import com.hexagonkt.serialization.jackson.JacksonHelper;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/hexagonkt/serialization/jackson/xml/Xml;", "Lcom/hexagonkt/serialization/SerializationFormat;", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "mediaType", "Lcom/hexagonkt/core/media/MediaType;", "getMediaType", "()Lcom/hexagonkt/core/media/MediaType;", "textFormat", "", "getTextFormat", "()Z", "writer", "Lcom/fasterxml/jackson/databind/ObjectWriter;", "createObjectWriter", "parse", "", "input", "Ljava/io/InputStream;", "serialize", "", "instance", "", "output", "Ljava/io/OutputStream;", "serialization_jackson_xml"})
public final class Xml
implements SerializationFormat {
    @NotNull
    public static final Xml INSTANCE = new Xml();
    @NotNull
    private static final ObjectMapper mapper;
    @NotNull
    private static final MediaType mediaType;
    private static final boolean textFormat;
    @NotNull
    private static final ObjectWriter writer;

    private Xml() {
    }

    @NotNull
    public MediaType getMediaType() {
        return mediaType;
    }

    public boolean getTextFormat() {
        return textFormat;
    }

    private final ObjectWriter createObjectWriter() {
        ObjectWriter objectWriter = mapper.writer((PrettyPrinter)new DefaultXmlPrettyPrinter());
        Intrinsics.checkNotNullExpressionValue((Object)objectWriter, (String)"writer(...)");
        return objectWriter;
    }

    public void serialize(@NotNull Object instance, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        writer.writeValue(output, instance);
    }

    @NotNull
    public String serialize(@NotNull Object instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        String string = writer.writeValueAsString(instance);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    @NotNull
    public Object parse(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        JsonNode jsonNode = mapper.readTree(input);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
        return JacksonHelper.INSTANCE.mapNode(jsonNode);
    }

    @NotNull
    public Object parse(@NotNull String input) {
        return SerializationFormat.DefaultImpls.parse((SerializationFormat)this, (String)input);
    }

    @NotNull
    public byte[] serializeBytes(@NotNull Object instance) {
        return SerializationFormat.DefaultImpls.serializeBytes((SerializationFormat)this, (Object)instance);
    }

    static {
        ObjectMapper objectMapper = new XmlMapper(new JacksonXmlModule()).configure(SerializationFeature.INDENT_OUTPUT, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"configure(...)");
        mapper = objectMapper;
        mediaType = MediaTypesKt.getAPPLICATION_XML();
        textFormat = true;
        writer = INSTANCE.createObjectWriter();
    }
}

