/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.maven;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleReader
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ConsoleReader.class);
    private InputStream inputStream;

    ConsoleReader(@NotNull InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public void run() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
            try {
                while (true) {
                    if (reader.ready()) {
                        log.info(reader.readLine());
                        continue;
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        log.error("An interruptedException occurred while reading the console!", (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error("An exception occurred while reading the console", (Throwable)e);
            return;
        }
    }
}

