/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.maven;

import com.hivemq.maven.ConsoleReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;
import org.stringtemplate.v4.ST;

@Mojo(name="hivemq", defaultPhase=LifecyclePhase.PACKAGE)
public class HiveMQMojo
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(HiveMQMojo.class);
    private static final ST DEBUG_PARAMETER_CLIENT = new ST("-agentlib:jdwp=transport=dt_socket,server=n,address=<host>:<port>");
    private static final ST DEBUG_PARAMETER_SERVER = new ST("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=<port>");
    private static final String DEBUG_MODE_CLIENT = "CLIENT";
    private static final String DEBUG_MODE_SERVER = "SERVER";
    private static final String DEBUG_MODE_NONE = "NONE";
    @Parameter(defaultValue="${project.artifactId}", required=true, readonly=true)
    String artifactId;
    @Parameter(defaultValue="${project.version}", required=true, readonly=true)
    String version;
    @Parameter(defaultValue="${basedir}", required=true, readonly=true)
    String baseDir;
    @Parameter(property="extensionZipName", required=false)
    String extensionZipName;
    @Parameter(defaultValue="true", property="verbose", required=true)
    boolean verbose;
    @Parameter(defaultValue="false", property="noExtensions", required=true)
    boolean noExtensions;
    @Parameter(defaultValue="SERVER", property="debugMode", required=true)
    String debugMode;
    @Parameter(defaultValue="5005", property="debugPort", required=true)
    String debugPort;
    @Parameter(defaultValue="localhost", property="debugServerHostName", required=true)
    String debugServerHostName;
    @Parameter(defaultValue="${project.build.directory}", property="extensionDir", required=true)
    File extensionDirectory;
    @Parameter(property="hivemqDir", required=true)
    File hiveMQDir;
    @Parameter(defaultValue="hivemq.jar", property="hivemqJar", required=true)
    String hivemqJar;
    @Parameter(property="includeResources")
    File includeResources;

    public void execute() throws MojoExecutionException, MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        this.checkPreconditions();
        List<String> commands = this.assembleCommand();
        Process hivemqProcess = this.startHiveMQ(commands);
        if (!hivemqProcess.isAlive()) {
            throw new MojoFailureException("HiveMQ process could not be started!");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Stopping HiveMQ process.");
            hivemqProcess.destroy();
            CompletableFuture<Process> processCompletableFuture = hivemqProcess.onExit();
            while (!processCompletableFuture.isDone()) {
                log.info("Waiting for HiveMQ to stop.");
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    log.error("An interruptedException occurred while waiting for HiveMQ to stop!");
                }
            }
        }));
        try {
            if (this.verbose) {
                this.showProcessOutputs(hivemqProcess);
            }
            hivemqProcess.waitFor();
        }
        catch (InterruptedException e) {
            throw new MojoFailureException("An interruptedException was thrown while HiveMQ was running!");
        }
    }

    private void showProcessOutputs(@NotNull Process hivemqProcess) {
        ConsoleReader reader = new ConsoleReader(hivemqProcess.getInputStream());
        Executors.newSingleThreadExecutor().submit(reader);
    }

    private void checkPreconditions() throws MojoExecutionException {
        if (!(DEBUG_MODE_CLIENT.equals(this.debugMode) || DEBUG_MODE_SERVER.equals(this.debugMode) || DEBUG_MODE_NONE.equals(this.debugMode))) {
            throw new MojoExecutionException("parameter 'debugMode' must be either CLIENT, SERVER or NONE");
        }
    }

    private Process startHiveMQ(@NotNull List<String> commandParameters) throws MojoExecutionException {
        Process p;
        ProcessBuilder processBuilder = new ProcessBuilder(commandParameters);
        processBuilder.directory(this.hiveMQDir);
        processBuilder.redirectErrorStream(true);
        try {
            p = processBuilder.start();
        }
        catch (IOException e) {
            log.error("An error occurred while starting HiveMQ:", (Throwable)e);
            throw new MojoExecutionException("An error occurred while starting HiveMQ!", (Exception)e);
        }
        return p;
    }

    private List<String> assembleCommand() throws MojoExecutionException {
        File hivemqBinDir = this.getHiveMQBinDir();
        File hivemqJarFile = this.getHiveMQJarFile(hivemqBinDir);
        ArrayList<String> commands = new ArrayList<String>();
        String javaHome = System.getProperty("java.home");
        String customJavaCommand = null;
        if (javaHome != null && !javaHome.isEmpty() && javaHome.trim().length() > 0) {
            File javaBin;
            if (SystemUtils.IS_OS_WINDOWS) {
                File javaExe = new File(new File(javaHome), "\\bin\\java.exe");
                if (javaExe.exists()) {
                    customJavaCommand = javaExe.getAbsolutePath();
                }
            } else if (SystemUtils.IS_OS_UNIX && (javaBin = new File(new File(javaHome), "/bin/java")).exists()) {
                customJavaCommand = javaBin.getAbsolutePath();
            }
        }
        if (customJavaCommand == null) {
            commands.add("java");
        } else {
            commands.add(customJavaCommand);
        }
        if (DEBUG_MODE_CLIENT.equals(this.debugMode)) {
            DEBUG_PARAMETER_CLIENT.add("port", (Object)this.debugPort).add("host", (Object)this.debugServerHostName);
            commands.add(DEBUG_PARAMETER_CLIENT.render());
        } else if (DEBUG_MODE_SERVER.equals(this.debugMode)) {
            DEBUG_PARAMETER_SERVER.add("port", (Object)this.debugPort);
            commands.add(DEBUG_PARAMETER_SERVER.render());
        }
        Optional<String> debugFolder = this.createExtensionFolder();
        debugFolder.ifPresent(commands::add);
        commands.add("-Djava.net.preferIPv4Stack=true");
        commands.add("-Dhivemq.home=" + this.hiveMQDir.getAbsolutePath());
        commands.add("-noverify");
        commands.add("--add-opens");
        commands.add("java.base/java.lang=ALL-UNNAMED");
        commands.add("--add-opens");
        commands.add("java.base/java.nio=ALL-UNNAMED");
        commands.add("--add-opens");
        commands.add("java.base/sun.nio.ch=ALL-UNNAMED");
        commands.add("--add-opens");
        commands.add("jdk.management/com.sun.management.internal=ALL-UNNAMED");
        commands.add("--add-exports");
        commands.add("java.base/jdk.internal.misc=ALL-UNNAMED");
        commands.add("-jar");
        commands.add(hivemqJarFile.getAbsolutePath());
        return commands;
    }

    File getHiveMQJarFile(@NotNull File hivemqBinDir) throws MojoExecutionException {
        File hivemqJarFile = new File(hivemqBinDir, this.hivemqJar);
        if (!hivemqJarFile.exists()) {
            throw new MojoExecutionException("HiveMQ Jar file " + hivemqJarFile.getAbsolutePath() + " does not exist!");
        }
        log.debug("HiveMQ jar file is located at {}", (Object)hivemqJarFile.getAbsolutePath());
        return hivemqJarFile;
    }

    File getHiveMQBinDir() throws MojoExecutionException {
        File hivemqBinDir = new File(this.hiveMQDir, "bin");
        log.debug("HiveMQ bin directory is located at {}", (Object)hivemqBinDir.getAbsolutePath());
        if (!hivemqBinDir.isDirectory()) {
            throw new MojoExecutionException(hivemqBinDir.getAbsolutePath() + " is not a directory!");
        }
        return hivemqBinDir;
    }

    Optional<String> createExtensionFolder() throws MojoExecutionException {
        boolean mkdirsSuccessful;
        File extensionZipFile;
        if (this.noExtensions) {
            return Optional.empty();
        }
        if (this.extensionZipName == null) {
            this.extensionZipName = this.artifactId + "-" + this.version + "-distribution.zip";
        }
        if (!(extensionZipFile = new File(this.extensionDirectory, this.extensionZipName)).exists()) {
            throw new MojoExecutionException("Could not find extension zip file " + extensionZipFile.getAbsolutePath());
        }
        File debugFolder = new File(this.extensionDirectory, "debug");
        if (debugFolder.exists()) {
            try {
                FileUtils.deleteDirectory((File)debugFolder);
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error occurred while deleting " + debugFolder.getAbsolutePath(), (Exception)e);
            }
        }
        if (!(mkdirsSuccessful = debugFolder.mkdirs())) {
            throw new MojoExecutionException("Could not create " + debugFolder.getAbsolutePath());
        }
        try {
            ZipFile zipFile = new ZipFile(extensionZipFile.getAbsolutePath());
            zipFile.extractAll(debugFolder.getAbsolutePath());
        }
        catch (ZipException e) {
            throw new MojoExecutionException("Error while copying extension to debug folder", (Exception)((Object)e));
        }
        try {
            if (this.includeResources != null) {
                FileUtils.copyDirectory((File)this.includeResources, (File)new File(debugFolder.getAbsolutePath() + File.separator + this.artifactId + File.separator + this.includeResources.getName()));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while copying resource to debug folder", e);
        }
        return Optional.of("-Dhivemq.extensions.folder=" + debugFolder.getAbsolutePath());
    }
}

