/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.mqtt3.reactor;

import com.hivemq.client.internal.mqtt.message.connect.mqtt3.Mqtt3ConnectView;
import com.hivemq.client.internal.mqtt.message.connect.mqtt3.Mqtt3ConnectViewBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscribeViewBuilder;
import com.hivemq.client.internal.mqtt.message.unsubscribe.mqtt3.Mqtt3UnsubscribeViewBuilder;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3BlockingClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientConfig;
import com.hivemq.client.mqtt.mqtt3.Mqtt3RxClient;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3Connect;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAck;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3PublishResult;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscribe;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.suback.Mqtt3SubAck;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3Unsubscribe;
import com.hivemq.client.mqtt.mqtt3.reactor.Mqtt3ReactorClient;
import com.hivemq.client.rx.reactor.FluxWithSingle;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.adapter.rxjava.RxJava2Adapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Mqtt3ReactorClientView
implements Mqtt3ReactorClient {
    @NotNull
    private final Mqtt3RxClient delegate;

    public Mqtt3ReactorClientView(@NotNull Mqtt3RxClient delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Mono<Mqtt3ConnAck> connect() {
        return this.connect((Mqtt3Connect)Mqtt3ConnectView.DEFAULT);
    }

    @Override
    @NotNull
    public Mono<Mqtt3ConnAck> connect(@NotNull Mqtt3Connect connect) {
        return RxJava2Adapter.singleToMono((Single)this.delegate.connect(connect));
    }

    @NotNull
    public Mqtt3ConnectViewBuilder.Nested<Mono<Mqtt3ConnAck>> connectWith() {
        return new Mqtt3ConnectViewBuilder.Nested(this::connect);
    }

    @Override
    @NotNull
    public Mono<Mqtt3SubAck> subscribe(@NotNull Mqtt3Subscribe subscribe) {
        return RxJava2Adapter.singleToMono((Single)this.delegate.subscribe(subscribe));
    }

    @NotNull
    public Mqtt3SubscribeViewBuilder.Nested<Mono<Mqtt3SubAck>> subscribeWith() {
        return new Mqtt3SubscribeViewBuilder.Nested(this::subscribe);
    }

    @Override
    @NotNull
    public FluxWithSingle<Mqtt3Publish, Mqtt3SubAck> subscribePublishes(@NotNull Mqtt3Subscribe subscribe) {
        return this.subscribePublishes(subscribe, false);
    }

    @Override
    @NotNull
    public FluxWithSingle<Mqtt3Publish, Mqtt3SubAck> subscribePublishes(@NotNull Mqtt3Subscribe subscribe, boolean manualAcknowledgement) {
        return FluxWithSingle.from(this.delegate.subscribePublishes(subscribe, manualAcknowledgement));
    }

    @NotNull
    public Mqtt3SubscribeViewPublishesBuilder subscribePublishesWith() {
        return new Mqtt3SubscribeViewPublishesBuilder();
    }

    @Override
    @NotNull
    public Flux<Mqtt3Publish> publishes(@NotNull MqttGlobalPublishFilter filter) {
        return this.publishes(filter, false);
    }

    @Override
    @NotNull
    public Flux<Mqtt3Publish> publishes(@NotNull MqttGlobalPublishFilter filter, boolean manualAcknowledgement) {
        return RxJava2Adapter.flowableToFlux((Flowable)this.delegate.publishes(filter, manualAcknowledgement));
    }

    @Override
    @NotNull
    public Mono<Void> unsubscribe(@NotNull Mqtt3Unsubscribe unsubscribe) {
        return RxJava2Adapter.completableToMono((Completable)this.delegate.unsubscribe(unsubscribe));
    }

    @NotNull
    public Mqtt3UnsubscribeViewBuilder.Nested<Mono<Void>> unsubscribeWith() {
        return new Mqtt3UnsubscribeViewBuilder.Nested(this::unsubscribe);
    }

    @Override
    @NotNull
    public Flux<Mqtt3PublishResult> publish(@NotNull Publisher<Mqtt3Publish> publisher) {
        return RxJava2Adapter.flowableToFlux((Flowable)this.delegate.publish(Flowable.fromPublisher(publisher)));
    }

    @Override
    @NotNull
    public Mono<Void> disconnect() {
        return RxJava2Adapter.completableToMono((Completable)this.delegate.disconnect());
    }

    @NotNull
    public Mqtt3ClientConfig getConfig() {
        return this.delegate.getConfig();
    }

    @NotNull
    public Mqtt3RxClient toRx() {
        return this.delegate;
    }

    @NotNull
    public Mqtt3AsyncClient toAsync() {
        return this.delegate.toAsync();
    }

    @NotNull
    public Mqtt3BlockingClient toBlocking() {
        return this.delegate.toBlocking();
    }

    private class Mqtt3SubscribeViewPublishesBuilder
    extends Mqtt3SubscribeViewBuilder.Publishes<FluxWithSingle<Mqtt3Publish, Mqtt3SubAck>> {
        private Mqtt3SubscribeViewPublishesBuilder() {
        }

        @NotNull
        public FluxWithSingle<Mqtt3Publish, Mqtt3SubAck> applySubscribe() {
            return Mqtt3ReactorClientView.this.subscribePublishes((Mqtt3Subscribe)this.build(), this.manualAcknowledgement);
        }
    }
}

