/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.reactor;

import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectBuilder;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnectBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribeBuilder;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribeBuilder;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.mqtt5.Mqtt5AsyncClient;
import com.hivemq.client.mqtt.mqtt5.Mqtt5BlockingClient;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientConfig;
import com.hivemq.client.mqtt.mqtt5.Mqtt5RxClient;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscribe;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAck;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.Mqtt5Unsubscribe;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.unsuback.Mqtt5UnsubAck;
import com.hivemq.client.mqtt.mqtt5.reactor.Mqtt5ReactorClient;
import com.hivemq.client.rx.reactor.FluxWithSingle;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.adapter.rxjava.RxJava2Adapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MqttReactorClient
implements Mqtt5ReactorClient {
    @NotNull
    private final Mqtt5RxClient delegate;

    public MqttReactorClient(@NotNull Mqtt5RxClient delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Mono<Mqtt5ConnAck> connect() {
        return this.connect((Mqtt5Connect)MqttConnect.DEFAULT);
    }

    @Override
    @NotNull
    public Mono<Mqtt5ConnAck> connect(@NotNull Mqtt5Connect connect) {
        return RxJava2Adapter.singleToMono((Single)this.delegate.connect(connect));
    }

    @NotNull
    public MqttConnectBuilder.Nested<Mono<Mqtt5ConnAck>> connectWith() {
        return new MqttConnectBuilder.Nested(this::connect);
    }

    @Override
    @NotNull
    public Mono<Mqtt5SubAck> subscribe(@NotNull Mqtt5Subscribe subscribe) {
        return RxJava2Adapter.singleToMono((Single)this.delegate.subscribe(subscribe));
    }

    @NotNull
    public MqttSubscribeBuilder.Nested<Mono<Mqtt5SubAck>> subscribeWith() {
        return new MqttSubscribeBuilder.Nested(this::subscribe);
    }

    @Override
    @NotNull
    public FluxWithSingle<Mqtt5Publish, Mqtt5SubAck> subscribePublishes(@NotNull Mqtt5Subscribe subscribe) {
        return this.subscribePublishes(subscribe, false);
    }

    @Override
    @NotNull
    public FluxWithSingle<Mqtt5Publish, Mqtt5SubAck> subscribePublishes(@NotNull Mqtt5Subscribe subscribe, boolean manualAcknowledgement) {
        return FluxWithSingle.from(this.delegate.subscribePublishes(subscribe, manualAcknowledgement));
    }

    @NotNull
    public MqttSubscribePublishesBuilder subscribePublishesWith() {
        return new MqttSubscribePublishesBuilder();
    }

    @Override
    @NotNull
    public Flux<Mqtt5Publish> publishes(@NotNull MqttGlobalPublishFilter filter) {
        return this.publishes(filter, false);
    }

    @Override
    @NotNull
    public Flux<Mqtt5Publish> publishes(@NotNull MqttGlobalPublishFilter filter, boolean manualAcknowledgement) {
        return RxJava2Adapter.flowableToFlux((Flowable)this.delegate.publishes(filter, manualAcknowledgement));
    }

    @Override
    @NotNull
    public Mono<Mqtt5UnsubAck> unsubscribe(@NotNull Mqtt5Unsubscribe unsubscribe) {
        return RxJava2Adapter.singleToMono((Single)this.delegate.unsubscribe(unsubscribe));
    }

    @NotNull
    public MqttUnsubscribeBuilder.Nested<Mono<Mqtt5UnsubAck>> unsubscribeWith() {
        return new MqttUnsubscribeBuilder.Nested(this::unsubscribe);
    }

    @Override
    @NotNull
    public Flux<Mqtt5PublishResult> publish(@NotNull Publisher<Mqtt5Publish> publisher) {
        return RxJava2Adapter.flowableToFlux((Flowable)this.delegate.publish(Flowable.fromPublisher(publisher)));
    }

    @Override
    @NotNull
    public Mono<Void> reauth() {
        return RxJava2Adapter.completableToMono((Completable)this.delegate.reauth());
    }

    @Override
    @NotNull
    public Mono<Void> disconnect() {
        return this.disconnect((Mqtt5Disconnect)MqttDisconnect.DEFAULT);
    }

    @Override
    @NotNull
    public Mono<Void> disconnect(@NotNull Mqtt5Disconnect disconnect) {
        return RxJava2Adapter.completableToMono((Completable)this.delegate.disconnect(disconnect));
    }

    @NotNull
    public MqttDisconnectBuilder.Nested<Mono<Void>> disconnectWith() {
        return new MqttDisconnectBuilder.Nested(this::disconnect);
    }

    @NotNull
    public Mqtt5ClientConfig getConfig() {
        return this.delegate.getConfig();
    }

    @NotNull
    public Mqtt5RxClient toRx() {
        return this.delegate;
    }

    @NotNull
    public Mqtt5AsyncClient toAsync() {
        return this.delegate.toAsync();
    }

    @NotNull
    public Mqtt5BlockingClient toBlocking() {
        return this.delegate.toBlocking();
    }

    private class MqttSubscribePublishesBuilder
    extends MqttSubscribeBuilder.Publishes<FluxWithSingle<Mqtt5Publish, Mqtt5SubAck>> {
        private MqttSubscribePublishesBuilder() {
        }

        @NotNull
        public FluxWithSingle<Mqtt5Publish, Mqtt5SubAck> applySubscribe() {
            return MqttReactorClient.this.subscribePublishes((Mqtt5Subscribe)this.build(), this.manualAcknowledgement);
        }
    }
}

