/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.rx.reactor.operators;

import com.hivemq.client.internal.rx.reactor.CoreWithSingleConditionalSubscriber;
import com.hivemq.client.rx.reactor.CoreWithSingleSubscriber;
import com.hivemq.client.rx.reactor.FluxWithSingle;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

class FluxWithSingleCombine<F, S>
extends Flux<Object> {
    @NotNull
    private final FluxWithSingle<F, S> source;

    FluxWithSingleCombine(@NotNull FluxWithSingle<F, S> source) {
        this.source = source;
    }

    public void subscribe(@NotNull CoreSubscriber<? super Object> subscriber) {
        this.source.subscribeBoth(new CombineSubscriber(subscriber));
    }

    static <F, S> void split(@NotNull Flux<Object> source, @NotNull CoreWithSingleSubscriber<? super F, ? super S> subscriber) {
        if (subscriber instanceof CoreWithSingleConditionalSubscriber) {
            source.subscribe(new SplitSubscriber.Conditional((CoreWithSingleConditionalSubscriber)subscriber));
        } else {
            source.subscribe(new SplitSubscriber.Default<F, S>(subscriber));
        }
    }

    private static class SingleElement {
        @NotNull
        final Object element;

        SingleElement(@NotNull Object element) {
            this.element = element;
        }
    }

    private static abstract class SplitSubscriber<F, S, T extends CoreWithSingleSubscriber<? super F, ? super S>>
    implements Fuseable.ConditionalSubscriber<Object>,
    Subscription {
        @NotNull
        final T subscriber;
        @Nullable
        private Subscription subscription;

        SplitSubscriber(@NotNull T subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            this.subscription = subscription;
            this.subscriber.onSubscribe((Subscription)this);
        }

        public void onNext(@NotNull Object o) {
            if (!this.tryOnNext(o)) {
                assert (this.subscription != null);
                this.subscription.request(1L);
            }
        }

        public boolean tryOnNext(@NotNull Object o) {
            if (o instanceof SingleElement) {
                this.subscriber.onSingle(((SingleElement)o).element);
                return false;
            }
            return this.tryOnNextActual(o);
        }

        abstract boolean tryOnNextActual(@NotNull F var1);

        public void onError(@NotNull Throwable throwable) {
            this.subscriber.onError(throwable);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public void request(long n) {
            assert (this.subscription != null);
            this.subscription.request(n);
        }

        public void cancel() {
            assert (this.subscription != null);
            this.subscription.cancel();
        }

        @NotNull
        public Context currentContext() {
            return this.subscriber.currentContext();
        }

        private static class Conditional<F, S>
        extends SplitSubscriber<F, S, CoreWithSingleConditionalSubscriber<? super F, ? super S>> {
            Conditional(@NotNull CoreWithSingleConditionalSubscriber<? super F, ? super S> subscriber) {
                super(subscriber);
            }

            @Override
            boolean tryOnNextActual(@NotNull F f) {
                return ((CoreWithSingleConditionalSubscriber)this.subscriber).tryOnNext(f);
            }
        }

        private static class Default<F, S>
        extends SplitSubscriber<F, S, CoreWithSingleSubscriber<? super F, ? super S>> {
            Default(@NotNull CoreWithSingleSubscriber<? super F, ? super S> subscriber) {
                super(subscriber);
            }

            @Override
            boolean tryOnNextActual(@NotNull F f) {
                this.subscriber.onNext(f);
                return true;
            }
        }
    }

    private static class CombineSubscriber<F, S>
    implements CoreWithSingleSubscriber<F, S>,
    Subscription {
        @NotNull
        private static final Object COMPLETE = new Object();
        @NotNull
        private static final AtomicLongFieldUpdater<CombineSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(CombineSubscriber.class, "requested");
        @NotNull
        private final CoreSubscriber<? super Object> subscriber;
        @Nullable
        private Subscription subscription;
        private volatile long requested;
        @Nullable
        private Object queued;
        @Nullable
        private Object done;

        CombineSubscriber(@NotNull CoreSubscriber<? super Object> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            this.subscription = subscription;
            this.subscriber.onSubscribe((Subscription)this);
        }

        public void onSingle(@NotNull S s) {
            this.next(new SingleElement(s));
        }

        public void onNext(@NotNull F f) {
            this.next(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void next(@NotNull Object next) {
            if (REQUESTED.get(this) == 0L) {
                CombineSubscriber combineSubscriber = this;
                synchronized (combineSubscriber) {
                    if (REQUESTED.get(this) == 0L) {
                        this.queued = next;
                        return;
                    }
                }
            }
            Operators.produced(REQUESTED, (Object)this, (long)1L);
            this.subscriber.onNext(next);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            CombineSubscriber combineSubscriber = this;
            synchronized (combineSubscriber) {
                if (this.queued != null) {
                    this.done = COMPLETE;
                } else {
                    this.subscriber.onComplete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(@NotNull Throwable error) {
            CombineSubscriber combineSubscriber = this;
            synchronized (combineSubscriber) {
                if (this.queued != null) {
                    this.done = error;
                } else {
                    this.subscriber.onError(error);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(long n) {
            assert (this.subscription != null);
            if (n > 0L) {
                if (Operators.addCap(REQUESTED, (Object)this, (long)n) == 0L) {
                    CombineSubscriber combineSubscriber = this;
                    synchronized (combineSubscriber) {
                        Object queued = this.queued;
                        if (queued != null) {
                            this.queued = null;
                            Operators.produced(REQUESTED, (Object)this, (long)1L);
                            this.subscriber.onNext(queued);
                            --n;
                            Object done = this.done;
                            if (done != null) {
                                this.done = null;
                                if (done instanceof Throwable) {
                                    this.subscriber.onError((Throwable)done);
                                } else {
                                    this.subscriber.onComplete();
                                }
                                return;
                            }
                        }
                        if (n > 0L) {
                            this.subscription.request(n);
                        }
                    }
                } else {
                    this.subscription.request(n);
                }
            }
        }

        public void cancel() {
            assert (this.subscription != null);
            this.subscription.cancel();
        }

        @NotNull
        public Context currentContext() {
            return this.subscriber.currentContext();
        }
    }
}

