/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.rx.reactor.operators;

import com.hivemq.client.internal.rx.reactor.CoreWithSingleConditionalSubscriber;
import com.hivemq.client.internal.rx.reactor.operators.FluxWithSingleOperator;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.rx.reactor.CoreWithSingleSubscriber;
import com.hivemq.client.rx.reactor.FluxWithSingle;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.util.context.Context;

public class FluxWithSingleMap<F, S, FM, SM>
extends FluxWithSingleOperator<F, S, FM, SM> {
    @Nullable
    private final Function<? super F, ? extends FM> fluxMapper;
    @NotNull
    private final Function<? super S, ? extends SM> singleMapper;

    @NotNull
    public static <F, S, FM, SM> FluxWithSingleMap<F, S, FM, SM> mapBoth(@NotNull FluxWithSingle<F, S> source, @Nullable Function<? super F, ? extends FM> fluxMapper, @NotNull Function<? super S, ? extends SM> singleMapper) {
        return new FluxWithSingleMap<F, S, FM, SM>(source, fluxMapper, singleMapper);
    }

    @NotNull
    public static <F, S, SM> FluxWithSingleMap<F, S, F, SM> mapSingle(@NotNull FluxWithSingle<F, S> source, @NotNull Function<? super S, ? extends SM> singleMapper) {
        return new FluxWithSingleMap(source, null, singleMapper);
    }

    private FluxWithSingleMap(@NotNull FluxWithSingle<F, S> source, @Nullable Function<? super F, ? extends FM> fluxMapper, @NotNull Function<? super S, ? extends SM> singleMapper) {
        super(source);
        this.fluxMapper = fluxMapper;
        this.singleMapper = singleMapper;
    }

    public void subscribe(@NotNull CoreSubscriber<? super FM> subscriber) {
        if (subscriber instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber conditional = (Fuseable.ConditionalSubscriber)subscriber;
            this.source.subscribeBoth(new MapSubscriber.Conditional<F, S, FM, SM, Fuseable.ConditionalSubscriber>(conditional, this.fluxMapper, this.singleMapper));
        } else {
            this.source.subscribeBoth(new MapSubscriber<F, S, FM, SM, CoreSubscriber<? super FM>>(subscriber, this.fluxMapper, this.singleMapper));
        }
    }

    @Override
    public void subscribeBoth(@NotNull CoreWithSingleSubscriber<? super FM, ? super SM> subscriber) {
        if (subscriber instanceof CoreWithSingleConditionalSubscriber) {
            CoreWithSingleConditionalSubscriber conditional = (CoreWithSingleConditionalSubscriber)subscriber;
            this.source.subscribeBoth(new WithSingleMapSubscriber.Conditional<F, S, FM, SM>(conditional, this.fluxMapper, this.singleMapper));
        } else {
            this.source.subscribeBoth(new WithSingleMapSubscriber<F, S, FM, SM>(subscriber, this.fluxMapper, this.singleMapper));
        }
    }

    private static class WithSingleMapSubscriber<F, S, FM, SM>
    extends MapSubscriber<F, S, FM, SM, CoreWithSingleSubscriber<? super FM, ? super SM>> {
        WithSingleMapSubscriber(@NotNull CoreWithSingleSubscriber<? super FM, ? super SM> subscriber, @Nullable Function<? super F, ? extends FM> fluxMapper, @NotNull Function<? super S, ? extends SM> singleMapper) {
            super(subscriber, fluxMapper, singleMapper);
        }

        @Override
        void onSingleMapped(@NotNull SM sm) {
            ((CoreWithSingleSubscriber)this.subscriber).onSingle(sm);
        }

        private static class Conditional<F, S, FM, SM>
        extends MapSubscriber.Conditional<F, S, FM, SM, CoreWithSingleConditionalSubscriber<? super FM, ? super SM>> {
            Conditional(@NotNull CoreWithSingleConditionalSubscriber<? super FM, ? super SM> subscriber, @Nullable Function<? super F, ? extends FM> fluxMapper, @NotNull Function<? super S, ? extends SM> singleMapper) {
                super(subscriber, fluxMapper, singleMapper);
            }

            @Override
            void onSingleMapped(@NotNull SM sm) {
                ((CoreWithSingleConditionalSubscriber)this.subscriber).onSingle(sm);
            }
        }
    }

    private static class MapSubscriber<F, S, FM, SM, T extends CoreSubscriber<? super FM>>
    implements CoreWithSingleSubscriber<F, S>,
    Subscription {
        @NotNull
        final T subscriber;
        @Nullable
        final Function<? super F, ? extends FM> fluxMapper;
        @NotNull
        private final Function<? super S, ? extends SM> singleMapper;
        @Nullable
        private Subscription subscription;

        MapSubscriber(@NotNull T subscriber, @Nullable Function<? super F, ? extends FM> fluxMapper, @NotNull Function<? super S, ? extends SM> singleMapper) {
            this.subscriber = subscriber;
            this.fluxMapper = fluxMapper;
            this.singleMapper = singleMapper;
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            this.subscription = subscription;
            this.subscriber.onSubscribe((Subscription)this);
        }

        public void onSingle(@NotNull S s) {
            Object sm;
            try {
                sm = Checks.notNull(this.singleMapper.apply(s), (String)"Mapped single value");
            }
            catch (Throwable throwable) {
                this.fail(throwable);
                return;
            }
            this.onSingleMapped(sm);
        }

        void onSingleMapped(@NotNull SM sm) {
        }

        public void onNext(@NotNull F f) {
            if (this.fluxMapper == null) {
                this.subscriber.onNext(f);
            } else {
                Object fm;
                try {
                    fm = Checks.notNull(this.fluxMapper.apply(f), (String)"Mapped value");
                }
                catch (Throwable throwable) {
                    this.fail(throwable);
                    return;
                }
                this.subscriber.onNext(fm);
            }
        }

        void fail(@NotNull Throwable throwable) {
            assert (this.subscription != null);
            Exceptions.throwIfFatal((Throwable)throwable);
            this.subscription.cancel();
            this.onError(throwable);
        }

        public void onError(@NotNull Throwable error) {
            this.subscriber.onError(error);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public void request(long n) {
            assert (this.subscription != null);
            this.subscription.request(n);
        }

        public void cancel() {
            assert (this.subscription != null);
            this.subscription.cancel();
        }

        @NotNull
        public Context currentContext() {
            return this.subscriber.currentContext();
        }

        private static class Conditional<F, S, FM, SM, T extends Fuseable.ConditionalSubscriber<? super FM>>
        extends MapSubscriber<F, S, FM, SM, T>
        implements CoreWithSingleConditionalSubscriber<F, S> {
            Conditional(@NotNull T subscriber, @Nullable Function<? super F, ? extends FM> fluxMapper, @NotNull Function<? super S, ? extends SM> singleMapper) {
                super(subscriber, fluxMapper, singleMapper);
            }

            public boolean tryOnNext(@NotNull F f) {
                Object fm;
                if (this.fluxMapper == null) {
                    return ((Fuseable.ConditionalSubscriber)this.subscriber).tryOnNext(f);
                }
                try {
                    fm = Checks.notNull(this.fluxMapper.apply(f), (String)"Mapped value");
                }
                catch (Throwable throwable) {
                    this.fail(throwable);
                    return false;
                }
                return ((Fuseable.ConditionalSubscriber)this.subscriber).tryOnNext(fm);
            }
        }
    }
}

