/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.rx.reactor;

import com.hivemq.client.internal.rx.reactor.CoreWithSingleStrictSubscriber;
import com.hivemq.client.internal.rx.reactor.operators.FluxWithSingleFrom;
import com.hivemq.client.internal.rx.reactor.operators.FluxWithSingleMap;
import com.hivemq.client.internal.rx.reactor.operators.FluxWithSinglePublishOn;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.rx.reactivestreams.PublisherWithSingle;
import com.hivemq.client.rx.reactivestreams.WithSingleSubscriber;
import com.hivemq.client.rx.reactor.CorePublisherWithSingle;
import com.hivemq.client.rx.reactor.CoreWithSingleSubscriber;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

public abstract class FluxWithSingle<F, S>
extends Flux<F>
implements CorePublisherWithSingle<F, S> {
    @NotNull
    public static <F, S> FluxWithSingle<F, S> from(@NotNull PublisherWithSingle<? extends F, ? extends S> source) {
        if (source instanceof FluxWithSingle) {
            return (FluxWithSingle)source;
        }
        return new FluxWithSingleFrom<F, S>(source);
    }

    @NotNull
    public final FluxWithSingle<F, S> publishBothOn(@NotNull Scheduler scheduler) {
        return this.publishBothOn(scheduler, Queues.SMALL_BUFFER_SIZE);
    }

    @NotNull
    public final FluxWithSingle<F, S> publishBothOn(@NotNull Scheduler scheduler, int prefetch) {
        return this.publishBothOn(scheduler, true, prefetch);
    }

    @NotNull
    public final FluxWithSingle<F, S> publishBothOn(@NotNull Scheduler scheduler, boolean delayError, int prefetch) {
        Checks.notNull((Object)scheduler, (String)"Scheduler");
        return new FluxWithSinglePublishOn(this, scheduler, delayError, prefetch);
    }

    @NotNull
    public final <SM> FluxWithSingle<F, SM> mapSingle(@NotNull Function<? super S, ? extends SM> singleMapper) {
        Checks.notNull(singleMapper, (String)"Single mapper");
        return FluxWithSingleMap.mapSingle(this, singleMapper);
    }

    @NotNull
    public final <FM, SM> FluxWithSingle<FM, SM> mapBoth(@NotNull Function<? super F, ? extends FM> fluxMapper, @NotNull Function<? super S, ? extends SM> singleMapper) {
        Checks.notNull(fluxMapper, (String)"Flux mapper");
        Checks.notNull(singleMapper, (String)"Single mapper");
        return FluxWithSingleMap.mapBoth(this, fluxMapper, singleMapper);
    }

    @NotNull
    public final FluxWithSingle<F, S> doOnSingle(@NotNull Consumer<? super S> singleConsumer) {
        Checks.notNull(singleConsumer, (String)"Single consumer");
        return FluxWithSingleMap.mapSingle(this, s -> {
            singleConsumer.accept((Object)s);
            return s;
        });
    }

    @Override
    public final void subscribeBoth(@NotNull WithSingleSubscriber<? super F, ? super S> subscriber) {
        if (subscriber instanceof CoreWithSingleSubscriber) {
            this.subscribeBoth((CoreWithSingleSubscriber)subscriber);
        } else {
            Checks.notNull(subscriber, (String)"Subscriber");
            this.subscribeBoth(new CoreWithSingleStrictSubscriber<F, S>(subscriber));
        }
    }

    @NotNull
    public final CompletableFuture<S> subscribeSingleFuture() {
        SingleFutureSubscriber singleFutureSubscriber = new SingleFutureSubscriber(this);
        CompletableFuture future = singleFutureSubscriber.getFutureBeforeSubscribe();
        singleFutureSubscriber.subscribe();
        return future;
    }

    @NotNull
    public final CompletableFuture<S> subscribeSingleFuture(@NotNull Consumer<? super F> consumer) {
        SingleFutureSubscriber singleFutureSubscriber = new SingleFutureSubscriber(this);
        CompletableFuture future = singleFutureSubscriber.getFutureBeforeSubscribe();
        singleFutureSubscriber.subscribe(consumer);
        return future;
    }

    @NotNull
    public final CompletableFuture<S> subscribeSingleFuture(@NotNull Consumer<? super F> consumer, @NotNull Consumer<? super Throwable> errorConsumer) {
        SingleFutureSubscriber singleFutureSubscriber = new SingleFutureSubscriber(this);
        CompletableFuture future = singleFutureSubscriber.getFutureBeforeSubscribe();
        singleFutureSubscriber.subscribe(consumer, errorConsumer);
        return future;
    }

    @NotNull
    public final CompletableFuture<S> subscribeSingleFuture(@NotNull Consumer<? super F> consumer, @NotNull Consumer<? super Throwable> errorConsumer, @NotNull Runnable completeConsumer) {
        SingleFutureSubscriber singleFutureSubscriber = new SingleFutureSubscriber(this);
        CompletableFuture future = singleFutureSubscriber.getFutureBeforeSubscribe();
        singleFutureSubscriber.subscribe(consumer, errorConsumer, completeConsumer);
        return future;
    }

    @NotNull
    public final CompletableFuture<S> subscribeSingleFuture(@NotNull Consumer<? super F> consumer, @NotNull Consumer<? super Throwable> errorConsumer, @NotNull Runnable completeConsumer, @NotNull Context initialContext) {
        SingleFutureSubscriber singleFutureSubscriber = new SingleFutureSubscriber(this);
        CompletableFuture future = singleFutureSubscriber.getFutureBeforeSubscribe();
        singleFutureSubscriber.subscribe(consumer, errorConsumer, completeConsumer, initialContext);
        return future;
    }

    @NotNull
    public final CompletableFuture<S> subscribeSingleFuture(@NotNull Subscriber<? super F> subscriber) {
        SingleFutureSubscriber singleFutureSubscriber = new SingleFutureSubscriber(this);
        CompletableFuture future = singleFutureSubscriber.getFutureBeforeSubscribe();
        singleFutureSubscriber.subscribe(subscriber);
        return future;
    }

    private static class SingleFutureSubscriber<F, S>
    extends Flux<F>
    implements CoreWithSingleSubscriber<F, S>,
    Subscription {
        @NotNull
        private final FluxWithSingle<F, S> source;
        @Nullable
        private Subscriber<? super F> subscriber;
        private final @NotNull AtomicReference<@Nullable Subscription> subscription = new AtomicReference();
        private final @NotNull AtomicReference<@Nullable CompletableFuture<S>> future = new AtomicReference<1>(new CompletableFuture<S>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                future.set(null);
                this.cancel();
                return super.cancel(mayInterruptIfRunning);
            }
        });

        SingleFutureSubscriber(@NotNull FluxWithSingle<F, S> source) {
            this.source = source;
        }

        @NotNull
        CompletableFuture<S> getFutureBeforeSubscribe() {
            CompletableFuture<S> future = this.future.get();
            assert (future != null);
            return future;
        }

        public void subscribe(@NotNull CoreSubscriber<? super F> subscriber) {
            this.subscriber = subscriber;
            this.source.subscribeBoth(this);
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            assert (this.subscriber != null);
            if (!this.subscription.compareAndSet(null, subscription)) {
                this.cancel(subscription);
            }
            this.subscriber.onSubscribe((Subscription)this);
        }

        public void onSingle(@NotNull S s) {
            CompletableFuture future = this.future.getAndSet(null);
            if (future != null) {
                future.complete(s);
            }
        }

        public void onNext(@NotNull F f) {
            assert (this.subscriber != null);
            this.subscriber.onNext(f);
        }

        public void onComplete() {
            assert (this.subscriber != null);
            CompletableFuture future = this.future.getAndSet(null);
            if (future != null) {
                future.completeExceptionally(new NoSuchElementException());
            }
            this.subscriber.onComplete();
        }

        public void onError(@NotNull Throwable t) {
            assert (this.subscriber != null);
            CompletableFuture future = this.future.getAndSet(null);
            if (future != null) {
                future.completeExceptionally(t);
            }
            this.subscriber.onError(t);
        }

        public void request(long n) {
            Subscription subscription = this.subscription.get();
            assert (subscription != null);
            if (subscription != this) {
                subscription.request(n);
            }
        }

        public void cancel() {
            Subscription subscription = this.subscription.getAndSet(this);
            if (subscription != null && subscription != this) {
                this.cancel(subscription);
            }
        }

        private void cancel(@NotNull Subscription subscription) {
            subscription.cancel();
            CompletableFuture future = this.future.getAndSet(null);
            if (future != null) {
                future.cancel(false);
            }
        }
    }
}

