/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttAsyncClient;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttRxClient;
import com.hivemq.client.internal.util.AsyncRuntimeException;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.mqtt5.Mqtt5BlockingClient;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5SubAckException;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5UnsubAckException;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5ReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscribe;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAck;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.Mqtt5Unsubscribe;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.unsuback.Mqtt5UnsubAck;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public class MqttBlockingClient
implements Mqtt5BlockingClient {
    @NotNull
    private final MqttRxClient delegate;

    @NotNull
    static Mqtt5SubAck handleSubAck(@NotNull Mqtt5SubAck subAck) {
        for (Mqtt5ReasonCode mqtt5ReasonCode : subAck.getReasonCodes()) {
            if (!mqtt5ReasonCode.isError()) continue;
            throw new Mqtt5SubAckException(subAck, "SUBACK contains at least one error code.");
        }
        return subAck;
    }

    @NotNull
    static Mqtt5UnsubAck handleUnsubAck(@NotNull Mqtt5UnsubAck unsubAck) {
        for (Mqtt5ReasonCode mqtt5ReasonCode : unsubAck.getReasonCodes()) {
            if (!mqtt5ReasonCode.isError()) continue;
            throw new Mqtt5UnsubAckException(unsubAck, "UNSUBACK contains at least one error code.");
        }
        return unsubAck;
    }

    @NotNull
    static Mqtt5PublishResult handlePublish(@NotNull Mqtt5PublishResult publishResult) {
        Optional<Throwable> error = publishResult.getError();
        if (error.isPresent()) {
            Throwable throwable = error.get();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        return publishResult;
    }

    MqttBlockingClient(@NotNull MqttRxClient delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Mqtt5ConnAck connect(@Nullable Mqtt5Connect connect) {
        try {
            return (Mqtt5ConnAck)this.delegate.connectUnsafe(connect).blockingGet();
        }
        catch (RuntimeException e) {
            throw AsyncRuntimeException.fillInStackTrace(e);
        }
    }

    @Override
    @NotNull
    public Mqtt5SubAck subscribe(@Nullable Mqtt5Subscribe subscribe) {
        try {
            return MqttBlockingClient.handleSubAck((Mqtt5SubAck)this.delegate.subscribeUnsafe(subscribe).blockingGet());
        }
        catch (RuntimeException e) {
            throw AsyncRuntimeException.fillInStackTrace(e);
        }
    }

    @Override
    @NotNull
    public Mqtt5BlockingClient.Mqtt5Publishes publishes(@Nullable MqttGlobalPublishFilter filter) {
        return new MqttPublishes(this.delegate.publishesUnsafe(filter));
    }

    @Override
    @NotNull
    public Mqtt5UnsubAck unsubscribe(@Nullable Mqtt5Unsubscribe unsubscribe) {
        try {
            return MqttBlockingClient.handleUnsubAck((Mqtt5UnsubAck)this.delegate.unsubscribeUnsafe(unsubscribe).blockingGet());
        }
        catch (RuntimeException e) {
            throw AsyncRuntimeException.fillInStackTrace(e);
        }
    }

    @Override
    @NotNull
    public Mqtt5PublishResult publish(@Nullable Mqtt5Publish publish) {
        Checks.notNull(publish, "Publish");
        try {
            return MqttBlockingClient.handlePublish((Mqtt5PublishResult)this.delegate.publishUnsafe((Flowable<Mqtt5Publish>)Flowable.just((Object)publish)).singleOrError().blockingGet());
        }
        catch (RuntimeException e) {
            throw AsyncRuntimeException.fillInStackTrace(e);
        }
    }

    @Override
    public void reauth() {
        try {
            this.delegate.reauthUnsafe().blockingAwait();
        }
        catch (RuntimeException e) {
            throw AsyncRuntimeException.fillInStackTrace(e);
        }
    }

    @Override
    public void disconnect(@NotNull Mqtt5Disconnect disconnect) {
        try {
            this.delegate.disconnectUnsafe(disconnect).blockingAwait();
        }
        catch (RuntimeException e) {
            throw AsyncRuntimeException.fillInStackTrace(e);
        }
    }

    @Override
    @NotNull
    public MqttClientConfig getConfig() {
        return this.delegate.getConfig();
    }

    @Override
    @NotNull
    public MqttRxClient toRx() {
        return this.delegate;
    }

    @Override
    @NotNull
    public MqttAsyncClient toAsync() {
        return this.delegate.toAsync();
    }

    private static class MqttPublishes
    implements Mqtt5BlockingClient.Mqtt5Publishes,
    FlowableSubscriber<Mqtt5Publish> {
        private final @NotNull AtomicReference<@Nullable Subscription> subscription = new AtomicReference();
        @NotNull
        private final LinkedList<Entry> entries = new LinkedList();
        @Nullable
        private Mqtt5Publish queuedPublish;
        private boolean cancelled;

        MqttPublishes(@NotNull Flowable<Mqtt5Publish> publishes) {
            publishes.subscribe((FlowableSubscriber)this);
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            if (this.subscription.compareAndSet(null, subscription)) {
                subscription.request(1L);
            } else {
                subscription.cancel();
            }
        }

        private void request() {
            Subscription subscription = this.subscription.get();
            assert (subscription != null);
            subscription.request(1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(@NotNull Mqtt5Publish publish) {
            LinkedList<Entry> linkedList = this.entries;
            synchronized (linkedList) {
                Entry entry;
                if (this.cancelled) {
                    return;
                }
                while ((entry = this.entries.poll()) != null) {
                    boolean success = entry.result.compareAndSet(null, publish);
                    entry.latch.countDown();
                    if (!success) continue;
                    this.request();
                    return;
                }
                this.queuedPublish = publish;
            }
        }

        public void onComplete() {
            this.onError(new IllegalStateException());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(@NotNull Throwable t) {
            LinkedList<Entry> linkedList = this.entries;
            synchronized (linkedList) {
                Entry entry;
                if (this.cancelled) {
                    return;
                }
                while ((entry = this.entries.poll()) != null) {
                    entry.result.set(t);
                    entry.latch.countDown();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Mqtt5Publish receive() throws InterruptedException {
            Entry entry;
            LinkedList<Entry> linkedList = this.entries;
            synchronized (linkedList) {
                if (this.cancelled) {
                    throw new CancellationException();
                }
                Mqtt5Publish publish = this.receiveNowUnsafe();
                if (publish != null) {
                    return publish;
                }
                entry = new Entry();
                this.entries.offer(entry);
            }
            InterruptedException interruptedException = null;
            try {
                entry.latch.await();
            }
            catch (InterruptedException e) {
                interruptedException = e;
            }
            Object result = entry.result.getAndSet(Entry.CANCELLED);
            if (result instanceof Mqtt5Publish) {
                return (Mqtt5Publish)result;
            }
            if (result instanceof Throwable) {
                if (result instanceof RuntimeException) {
                    throw AsyncRuntimeException.fillInStackTrace((RuntimeException)result);
                }
                throw new RuntimeException((Throwable)result);
            }
            if (interruptedException != null) {
                throw interruptedException;
            }
            throw new InterruptedException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Optional<Mqtt5Publish> receive(long timeout, @Nullable TimeUnit timeUnit) throws InterruptedException {
            Entry entry;
            if (timeout < 0L) {
                throw new IllegalArgumentException("Timeout must be greater than 0.");
            }
            Checks.notNull(timeUnit, "Time unit");
            LinkedList<Entry> linkedList = this.entries;
            synchronized (linkedList) {
                if (this.cancelled) {
                    throw new CancellationException();
                }
                Mqtt5Publish publish = this.receiveNowUnsafe();
                if (publish != null) {
                    return Optional.of(publish);
                }
                entry = new Entry();
                this.entries.offer(entry);
            }
            InterruptedException interruptedException = null;
            try {
                entry.latch.await(timeout, timeUnit);
            }
            catch (InterruptedException e) {
                interruptedException = e;
            }
            Object result = entry.result.getAndSet(Entry.CANCELLED);
            if (result instanceof Mqtt5Publish) {
                return Optional.of((Mqtt5Publish)result);
            }
            if (result instanceof Throwable) {
                if (result instanceof RuntimeException) {
                    throw AsyncRuntimeException.fillInStackTrace((RuntimeException)result);
                }
                throw new RuntimeException((Throwable)result);
            }
            if (interruptedException != null) {
                throw interruptedException;
            }
            return Optional.empty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Optional<Mqtt5Publish> receiveNow() {
            Mqtt5Publish publish;
            LinkedList<Entry> linkedList = this.entries;
            synchronized (linkedList) {
                if (this.cancelled) {
                    throw new CancellationException();
                }
                publish = this.receiveNowUnsafe();
            }
            return Optional.ofNullable(publish);
        }

        @Nullable
        private Mqtt5Publish receiveNowUnsafe() {
            if (this.queuedPublish != null) {
                Mqtt5Publish queuedPublish = this.queuedPublish;
                this.queuedPublish = null;
                this.request();
                return queuedPublish;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Subscription subscription = this.subscription.getAndSet((Subscription)SubscriptionHelper.CANCELLED);
            if (subscription != null) {
                subscription.cancel();
            }
            LinkedList<Entry> linkedList = this.entries;
            synchronized (linkedList) {
                Entry entry;
                if (this.cancelled) {
                    return;
                }
                this.cancelled = true;
                while ((entry = this.entries.poll()) != null) {
                    entry.result.set(new CancellationException());
                    entry.latch.countDown();
                }
            }
        }

        private static class Entry {
            @NotNull
            static final Object CANCELLED = new Object();
            @NotNull
            final CountDownLatch latch = new CountDownLatch(1);
            final @NotNull AtomicReference<@Nullable Object> result = new AtomicReference();

            private Entry() {
            }
        }
    }
}

