/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.MqttClientExecutorConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.internal.mqtt.advanced.MqttClientAdvancedConfig;
import com.hivemq.client.internal.mqtt.datatypes.MqttClientIdentifierImpl;
import com.hivemq.client.internal.mqtt.ioc.ClientComponent;
import com.hivemq.client.internal.mqtt.ioc.SingletonComponent;
import com.hivemq.client.internal.util.ExecutorUtil;
import com.hivemq.client.mqtt.MqttClientSslConfig;
import com.hivemq.client.mqtt.MqttClientState;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.MqttWebSocketConfig;
import com.hivemq.client.mqtt.datatypes.MqttClientIdentifier;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientConfig;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientConnectionConfig;
import com.hivemq.shaded.io.netty.channel.EventLoop;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class MqttClientConfig
implements Mqtt5ClientConfig {
    @NotNull
    private final MqttVersion mqttVersion;
    @NotNull
    private volatile MqttClientIdentifierImpl clientIdentifier;
    @NotNull
    private final String serverHost;
    private final int serverPort;
    @NotNull
    private final MqttClientExecutorConfigImpl executorConfig;
    @Nullable
    private final MqttClientSslConfigImpl sslConfig;
    @Nullable
    private final MqttWebSocketConfigImpl webSocketConfig;
    @NotNull
    private final MqttClientAdvancedConfig advancedConfig;
    @NotNull
    private final ClientComponent clientComponent;
    @Nullable
    private volatile EventLoop eventLoop;
    private int eventLoopAcquires;
    private long eventLoopAcquireCount;
    @NotNull
    private final Object eventLoopLock = new Object();
    @NotNull
    private final @NotNull AtomicReference<@NotNull MqttClientState> state;
    @Nullable
    private volatile MqttClientConnectionConfig connectionConfig;

    public MqttClientConfig(@NotNull MqttVersion mqttVersion, @NotNull MqttClientIdentifierImpl clientIdentifier, @NotNull String serverHost, int serverPort, @NotNull MqttClientExecutorConfigImpl executorConfig, @Nullable MqttClientSslConfigImpl sslConfig, @Nullable MqttWebSocketConfigImpl webSocketConfig, @NotNull MqttClientAdvancedConfig advancedConfig) {
        this.mqttVersion = mqttVersion;
        this.clientIdentifier = clientIdentifier;
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.executorConfig = executorConfig;
        this.sslConfig = sslConfig;
        this.webSocketConfig = webSocketConfig;
        this.advancedConfig = advancedConfig;
        this.clientComponent = SingletonComponent.INSTANCE.clientComponentBuilder().clientConfig(this).build();
        this.state = new AtomicReference<MqttClientState>(MqttClientState.DISCONNECTED);
    }

    @Override
    @NotNull
    public MqttVersion getMqttVersion() {
        return this.mqttVersion;
    }

    @Override
    @NotNull
    public Optional<MqttClientIdentifier> getClientIdentifier() {
        return this.clientIdentifier == MqttClientIdentifierImpl.REQUEST_CLIENT_IDENTIFIER_FROM_SERVER ? Optional.empty() : Optional.of(this.clientIdentifier);
    }

    @NotNull
    public MqttClientIdentifierImpl getRawClientIdentifier() {
        return this.clientIdentifier;
    }

    public void setClientIdentifier(@NotNull MqttClientIdentifierImpl clientIdentifier) {
        this.clientIdentifier = clientIdentifier;
    }

    @Override
    @NotNull
    public String getServerHost() {
        return this.serverHost;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    @NotNull
    public MqttClientExecutorConfigImpl getExecutorConfig() {
        return this.executorConfig;
    }

    @Override
    @NotNull
    public Optional<MqttClientSslConfig> getSslConfig() {
        return Optional.ofNullable(this.sslConfig);
    }

    @Nullable
    public MqttClientSslConfigImpl getRawSslConfig() {
        return this.sslConfig;
    }

    @Override
    @NotNull
    public Optional<MqttWebSocketConfig> getWebSocketConfig() {
        return Optional.ofNullable(this.webSocketConfig);
    }

    @Nullable
    public MqttWebSocketConfigImpl getRawWebSocketConfig() {
        return this.webSocketConfig;
    }

    @Override
    @NotNull
    public MqttClientAdvancedConfig getAdvancedConfig() {
        return this.advancedConfig;
    }

    @NotNull
    public ClientComponent getClientComponent() {
        return this.clientComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public EventLoop acquireEventLoop() {
        Object object = this.eventLoopLock;
        synchronized (object) {
            ++this.eventLoopAcquires;
            ++this.eventLoopAcquireCount;
            EventLoop eventLoop = this.eventLoop;
            if (eventLoop == null) {
                this.eventLoop = eventLoop = SingletonComponent.INSTANCE.nettyEventLoopProvider().acquireEventLoop(this.executorConfig.getRawNettyExecutor(), this.executorConfig.getRawNettyThreads());
            }
            return eventLoop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEventLoop() {
        Object object = this.eventLoopLock;
        synchronized (object) {
            if (--this.eventLoopAcquires == 0) {
                EventLoop eventLoop = this.eventLoop;
                long eventLoopAcquireCount = this.eventLoopAcquireCount;
                assert (eventLoop != null);
                eventLoop.execute(() -> {
                    Object object = this.eventLoopLock;
                    synchronized (object) {
                        if (eventLoopAcquireCount == this.eventLoopAcquireCount) {
                            this.eventLoop = null;
                            SingletonComponent.INSTANCE.nettyEventLoopProvider().releaseEventLoop(this.executorConfig.getRawNettyExecutor());
                        }
                    }
                });
            }
        }
    }

    public boolean executeInEventLoop(@NotNull Runnable runnable) {
        EventLoop eventLoop = this.eventLoop;
        if (eventLoop == null) {
            return false;
        }
        return ExecutorUtil.execute(eventLoop, runnable);
    }

    @Override
    @NotNull
    public MqttClientState getState() {
        return this.state.get();
    }

    @NotNull
    public @NotNull AtomicReference<@NotNull MqttClientState> getRawState() {
        return this.state;
    }

    @Override
    @NotNull
    public Optional<Mqtt5ClientConnectionConfig> getConnectionConfig() {
        return Optional.ofNullable(this.connectionConfig);
    }

    @Nullable
    public MqttClientConnectionConfig getRawConnectionConfig() {
        return this.connectionConfig;
    }

    public void setConnectionConfig(@Nullable MqttClientConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }
}

