/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttTopicAliasAutoMapping;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttTopicAliasMapping;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientConnectionConfig;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientConnectionConfig;
import com.hivemq.client.mqtt.mqtt5.auth.Mqtt5EnhancedAuthMechanism;
import com.hivemq.shaded.io.netty.channel.Channel;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.Optional;

public class MqttClientConnectionConfig
implements Mqtt5ClientConnectionConfig,
Mqtt5ClientConnectionConfig.RestrictionsForServer,
Mqtt5ClientConnectionConfig.RestrictionsForClient,
Mqtt3ClientConnectionConfig,
Mqtt3ClientConnectionConfig.RestrictionsForClient {
    private final int keepAlive;
    private final long sessionExpiryInterval;
    private final boolean hasWillPublish;
    @Nullable
    private final Mqtt5EnhancedAuthMechanism enhancedAuthMechanism;
    private final int receiveMaximum;
    private final int maximumPacketSize;
    private final int topicAliasMaximum;
    private final boolean problemInformationRequested;
    private final boolean responseInformationRequested;
    private final int sendMaximum;
    private final int sendMaximumPacketSize;
    @Nullable
    private final MqttTopicAliasMapping sendTopicAliasMapping;
    @NotNull
    private final MqttQos maximumQos;
    private final boolean retainAvailable;
    private final boolean wildcardSubscriptionAvailable;
    private final boolean sharedSubscriptionAvailable;
    private final boolean subscriptionIdentifiersAvailable;
    @NotNull
    private final Channel channel;

    public MqttClientConnectionConfig(int keepAlive, long sessionExpiryInterval, boolean hasWillPublish, @Nullable Mqtt5EnhancedAuthMechanism enhancedAuthMechanism, int receiveMaximum, int maximumPacketSize, int topicAliasMaximum, boolean problemInformationRequested, boolean responseInformationRequested, int sendMaximum, int sendMaximumPacketSize, int sendTopicAliasMaximum, @NotNull MqttQos maximumQos, boolean retainAvailable, boolean wildcardSubscriptionAvailable, boolean sharedSubscriptionAvailable, boolean subscriptionIdentifiersAvailable, @NotNull Channel channel) {
        this.keepAlive = keepAlive;
        this.sessionExpiryInterval = sessionExpiryInterval;
        this.hasWillPublish = hasWillPublish;
        this.enhancedAuthMechanism = enhancedAuthMechanism;
        this.receiveMaximum = receiveMaximum;
        this.maximumPacketSize = maximumPacketSize;
        this.topicAliasMaximum = topicAliasMaximum;
        this.problemInformationRequested = problemInformationRequested;
        this.responseInformationRequested = responseInformationRequested;
        this.sendMaximum = sendMaximum;
        this.sendMaximumPacketSize = sendMaximumPacketSize;
        this.sendTopicAliasMapping = sendTopicAliasMaximum == 0 ? null : new MqttTopicAliasAutoMapping(sendTopicAliasMaximum);
        this.maximumQos = maximumQos;
        this.retainAvailable = retainAvailable;
        this.wildcardSubscriptionAvailable = wildcardSubscriptionAvailable;
        this.sharedSubscriptionAvailable = sharedSubscriptionAvailable;
        this.subscriptionIdentifiersAvailable = subscriptionIdentifiersAvailable;
        this.channel = channel;
    }

    @Override
    public int getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public long getSessionExpiryInterval() {
        return this.sessionExpiryInterval;
    }

    @Override
    public boolean hasWillPublish() {
        return this.hasWillPublish;
    }

    @Override
    @NotNull
    public Optional<Mqtt5EnhancedAuthMechanism> getEnhancedAuthMechanism() {
        return Optional.ofNullable(this.enhancedAuthMechanism);
    }

    @Nullable
    public Mqtt5EnhancedAuthMechanism getRawEnhancedAuthMechanism() {
        return this.enhancedAuthMechanism;
    }

    @Override
    @NotNull
    public MqttClientConnectionConfig getRestrictionsForServer() {
        return this;
    }

    @Override
    @NotNull
    public MqttClientConnectionConfig getRestrictionsForClient() {
        return this;
    }

    @Override
    public int getReceiveMaximum() {
        return this.receiveMaximum;
    }

    @Override
    public int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    @Override
    public int getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    @Override
    public boolean isProblemInformationRequested() {
        return this.problemInformationRequested;
    }

    @Override
    public boolean isResponseInformationRequested() {
        return this.responseInformationRequested;
    }

    @Override
    public int getSendMaximum() {
        return this.sendMaximum;
    }

    @Override
    public int getSendMaximumPacketSize() {
        return this.sendMaximumPacketSize;
    }

    @Override
    public int getSendTopicAliasMaximum() {
        return this.sendTopicAliasMapping == null ? 0 : this.sendTopicAliasMapping.getTopicAliasMaximum();
    }

    @Nullable
    public MqttTopicAliasMapping getSendTopicAliasMapping() {
        return this.sendTopicAliasMapping;
    }

    @Override
    @NotNull
    public MqttQos getMaximumQos() {
        return this.maximumQos;
    }

    @Override
    public boolean isRetainAvailable() {
        return this.retainAvailable;
    }

    @Override
    public boolean isWildcardSubscriptionAvailable() {
        return this.wildcardSubscriptionAvailable;
    }

    @Override
    public boolean isSharedSubscriptionAvailable() {
        return this.sharedSubscriptionAvailable;
    }

    @Override
    public boolean areSubscriptionIdentifiersAvailable() {
        return this.subscriptionIdentifiersAvailable;
    }

    @NotNull
    public Channel getChannel() {
        return this.channel;
    }
}

