/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.MqttClientSslConfig;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class MqttClientSslConfigImpl
implements MqttClientSslConfig {
    @NotNull
    public static final MqttClientSslConfigImpl DEFAULT = new MqttClientSslConfigImpl(null, null, null, null, 10000L);
    @Nullable
    private final KeyManagerFactory keyManagerFactory;
    @Nullable
    private final TrustManagerFactory trustManagerFactory;
    @Nullable
    private final ImmutableList<String> cipherSuites;
    @Nullable
    private final ImmutableList<String> protocols;
    private final long handshakeTimeoutMs;

    MqttClientSslConfigImpl(@Nullable KeyManagerFactory keyManagerFactory, @Nullable TrustManagerFactory trustManagerFactory, @Nullable ImmutableList<String> cipherSuites, @Nullable ImmutableList<String> protocols, long handshakeTimeoutMs) {
        this.keyManagerFactory = keyManagerFactory;
        this.trustManagerFactory = trustManagerFactory;
        this.cipherSuites = cipherSuites;
        this.protocols = protocols;
        this.handshakeTimeoutMs = handshakeTimeoutMs;
    }

    @Override
    @NotNull
    public Optional<KeyManagerFactory> getKeyManagerFactory() {
        return Optional.ofNullable(this.keyManagerFactory);
    }

    @Nullable
    public KeyManagerFactory getRawKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    @Override
    @NotNull
    public Optional<TrustManagerFactory> getTrustManagerFactory() {
        return Optional.ofNullable(this.trustManagerFactory);
    }

    @Nullable
    public TrustManagerFactory getRawTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    @Override
    @NotNull
    public Optional<List<String>> getCipherSuites() {
        return Optional.ofNullable(this.cipherSuites);
    }

    @Nullable
    public ImmutableList<String> getRawCipherSuites() {
        return this.cipherSuites;
    }

    @Override
    @NotNull
    public Optional<List<String>> getProtocols() {
        return Optional.ofNullable(this.protocols);
    }

    @Nullable
    public ImmutableList<String> getRawProtocols() {
        return this.protocols;
    }

    @Override
    public long getHandshakeTimeoutMs() {
        return this.handshakeTimeoutMs;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttClientSslConfigImpl)) {
            return false;
        }
        MqttClientSslConfigImpl that = (MqttClientSslConfigImpl)o;
        return Objects.equals(this.keyManagerFactory, that.keyManagerFactory) && Objects.equals(this.trustManagerFactory, that.trustManagerFactory) && Objects.equals(this.cipherSuites, that.cipherSuites) && Objects.equals(this.protocols, that.protocols) && this.handshakeTimeoutMs == that.handshakeTimeoutMs;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.keyManagerFactory);
        result = 31 * result + Objects.hashCode(this.trustManagerFactory);
        result = 31 * result + Objects.hashCode(this.cipherSuites);
        result = 31 * result + Objects.hashCode(this.protocols);
        result = 31 * result + Long.hashCode(this.handshakeTimeoutMs);
        return result;
    }
}

