/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttAsyncClient;
import com.hivemq.client.internal.mqtt.MqttBlockingClient;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.handler.auth.MqttReAuthCompletable;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckSingle;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectCompletable;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttGlobalIncomingPublishFlowable;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscribedPublishFlowable;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttIncomingAckFlowable;
import com.hivemq.client.internal.mqtt.handler.subscribe.MqttSubAckSingle;
import com.hivemq.client.internal.mqtt.handler.subscribe.MqttUnsubAckSingle;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.mqtt5.Mqtt5RxClient;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscribe;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAck;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.Mqtt5Unsubscribe;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.unsuback.Mqtt5UnsubAck;
import com.hivemq.client.rx.FlowableWithSingle;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Function;

public class MqttRxClient
implements Mqtt5RxClient {
    @NotNull
    private static final Function<Mqtt5Publish, MqttPublish> PUBLISH_MAPPER = MqttChecks::publish;
    @NotNull
    private final MqttClientConfig clientConfig;

    public MqttRxClient(@NotNull MqttClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    @Override
    @NotNull
    public Single<Mqtt5ConnAck> connect(@Nullable Mqtt5Connect connect) {
        return this.connectUnsafe(connect).observeOn(this.clientConfig.getExecutorConfig().getApplicationScheduler());
    }

    @NotNull
    Single<Mqtt5ConnAck> connectUnsafe(@Nullable Mqtt5Connect connect) {
        MqttConnect mqttConnect = MqttChecks.connect(connect);
        return new MqttConnAckSingle(this.clientConfig, mqttConnect);
    }

    @Override
    @NotNull
    public Single<Mqtt5SubAck> subscribe(@Nullable Mqtt5Subscribe subscribe) {
        return this.subscribeUnsafe(subscribe).observeOn(this.clientConfig.getExecutorConfig().getApplicationScheduler());
    }

    @NotNull
    Single<Mqtt5SubAck> subscribeUnsafe(@Nullable Mqtt5Subscribe subscribe) {
        MqttSubscribe mqttSubscribe = MqttChecks.subscribe(subscribe);
        return new MqttSubAckSingle(mqttSubscribe, this.clientConfig);
    }

    @Override
    @NotNull
    public FlowableWithSingle<Mqtt5Publish, Mqtt5SubAck> subscribeStream(@Nullable Mqtt5Subscribe subscribe) {
        return this.subscribeStreamUnsafe(subscribe).observeOnBoth(this.clientConfig.getExecutorConfig().getApplicationScheduler(), true);
    }

    @NotNull
    FlowableWithSingle<Mqtt5Publish, Mqtt5SubAck> subscribeStreamUnsafe(@Nullable Mqtt5Subscribe subscribe) {
        MqttSubscribe mqttSubscribe = MqttChecks.subscribe(subscribe);
        return new MqttSubscribedPublishFlowable(mqttSubscribe, this.clientConfig);
    }

    @Override
    @NotNull
    public Flowable<Mqtt5Publish> publishes(@Nullable MqttGlobalPublishFilter filter) {
        return this.publishesUnsafe(filter).observeOn(this.clientConfig.getExecutorConfig().getApplicationScheduler(), true);
    }

    @NotNull
    Flowable<Mqtt5Publish> publishesUnsafe(@Nullable MqttGlobalPublishFilter filter) {
        Checks.notNull(filter, "Global publish filter");
        return new MqttGlobalIncomingPublishFlowable(filter, this.clientConfig);
    }

    @Override
    @NotNull
    public Single<Mqtt5UnsubAck> unsubscribe(@Nullable Mqtt5Unsubscribe unsubscribe) {
        return this.unsubscribeUnsafe(unsubscribe).observeOn(this.clientConfig.getExecutorConfig().getApplicationScheduler());
    }

    @NotNull
    Single<Mqtt5UnsubAck> unsubscribeUnsafe(@Nullable Mqtt5Unsubscribe unsubscribe) {
        MqttUnsubscribe mqttUnsubscribe = MqttChecks.unsubscribe(unsubscribe);
        return new MqttUnsubAckSingle(mqttUnsubscribe, this.clientConfig);
    }

    @Override
    @NotNull
    public Flowable<Mqtt5PublishResult> publish(@Nullable Flowable<Mqtt5Publish> publishFlowable) {
        Checks.notNull(publishFlowable, "Publish flowable");
        return this.publishHalfSafe((Flowable<Mqtt5Publish>)publishFlowable.subscribeOn(this.clientConfig.getExecutorConfig().getApplicationScheduler()));
    }

    @NotNull
    Flowable<Mqtt5PublishResult> publishHalfSafe(@NotNull Flowable<Mqtt5Publish> publishFlowable) {
        return this.publishUnsafe(publishFlowable).observeOn(this.clientConfig.getExecutorConfig().getApplicationScheduler(), true);
    }

    @NotNull
    Flowable<Mqtt5PublishResult> publishUnsafe(@NotNull Flowable<Mqtt5Publish> publishFlowable) {
        return new MqttIncomingAckFlowable((Flowable<MqttPublish>)publishFlowable.map(PUBLISH_MAPPER), this.clientConfig);
    }

    @Override
    @NotNull
    public Completable reauth() {
        return this.reauthUnsafe().observeOn(this.clientConfig.getExecutorConfig().getApplicationScheduler());
    }

    @NotNull
    Completable reauthUnsafe() {
        return new MqttReAuthCompletable(this.clientConfig);
    }

    @Override
    @NotNull
    public Completable disconnect(@Nullable Mqtt5Disconnect disconnect) {
        return this.disconnectUnsafe(disconnect).observeOn(this.clientConfig.getExecutorConfig().getApplicationScheduler());
    }

    @NotNull
    Completable disconnectUnsafe(@Nullable Mqtt5Disconnect disconnect) {
        MqttDisconnect mqttDisconnect = MqttChecks.disconnect(disconnect);
        return new MqttDisconnectCompletable(this.clientConfig, mqttDisconnect);
    }

    @Override
    @NotNull
    public MqttClientConfig getConfig() {
        return this.clientConfig;
    }

    @Override
    @NotNull
    public MqttAsyncClient toAsync() {
        return new MqttAsyncClient(this);
    }

    @Override
    @NotNull
    public MqttBlockingClient toBlocking() {
        return new MqttBlockingClient(this);
    }
}

