/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttAsyncClient;
import com.hivemq.client.internal.mqtt.MqttBlockingClient;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttRxClient;
import com.hivemq.client.internal.mqtt.MqttRxClientBuilderBase;
import com.hivemq.client.internal.mqtt.advanced.MqttClientAdvancedConfig;
import com.hivemq.client.internal.mqtt.advanced.MqttClientAdvancedConfigBuilder;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientBuilder;
import com.hivemq.client.mqtt.mqtt5.advanced.Mqtt5ClientAdvancedConfig;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;

public class MqttRxClientBuilder
extends MqttRxClientBuilderBase<MqttRxClientBuilder>
implements Mqtt5ClientBuilder {
    @NotNull
    private MqttClientAdvancedConfig advancedConfig = MqttClientAdvancedConfig.DEFAULT;

    public MqttRxClientBuilder() {
    }

    MqttRxClientBuilder(@NotNull MqttRxClientBuilderBase clientBuilder) {
        super(clientBuilder);
    }

    @Override
    @NotNull
    protected MqttRxClientBuilder self() {
        return this;
    }

    @Override
    @NotNull
    public MqttRxClientBuilder advancedConfig(@NotNull Mqtt5ClientAdvancedConfig advancedConfig) {
        this.advancedConfig = Checks.notImplemented(advancedConfig, MqttClientAdvancedConfig.class, "Advanced config");
        return this;
    }

    @NotNull
    public MqttClientAdvancedConfigBuilder.Nested<MqttRxClientBuilder> advancedConfig() {
        return new MqttClientAdvancedConfigBuilder.Nested<MqttRxClientBuilder>(this.advancedConfig, this::advancedConfig);
    }

    @Override
    @NotNull
    public MqttRxClient build() {
        return this.buildRx();
    }

    @Override
    @NotNull
    public MqttRxClient buildRx() {
        return new MqttRxClient(this.buildClientConfig());
    }

    @Override
    @NotNull
    public MqttAsyncClient buildAsync() {
        return this.buildRx().toAsync();
    }

    @Override
    @NotNull
    public MqttBlockingClient buildBlocking() {
        return this.buildRx().toBlocking();
    }

    @NotNull
    private MqttClientConfig buildClientConfig() {
        return new MqttClientConfig(MqttVersion.MQTT_5_0, this.identifier, this.serverHost, this.serverPort, this.executorConfig, this.sslConfig, this.webSocketConfig, this.advancedConfig);
    }
}

