/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttClientExecutorConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientExecutorConfigImplBuilder;
import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientSslConfigImplBuilder;
import com.hivemq.client.internal.mqtt.MqttRxClientBuilder;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttClientIdentifierImpl;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3RxClientViewBuilder;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttClientBuilder;
import com.hivemq.client.mqtt.MqttClientExecutorConfig;
import com.hivemq.client.mqtt.MqttClientSslConfig;
import com.hivemq.client.mqtt.MqttWebSocketConfig;
import com.hivemq.client.mqtt.datatypes.MqttClientIdentifier;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;

public abstract class MqttRxClientBuilderBase<B extends MqttRxClientBuilderBase<B>> {
    @NotNull
    protected MqttClientIdentifierImpl identifier = MqttClientIdentifierImpl.REQUEST_CLIENT_IDENTIFIER_FROM_SERVER;
    @NotNull
    protected String serverHost = "localhost";
    protected int serverPort = 1883;
    private boolean customServerPort = false;
    @Nullable
    protected MqttClientSslConfigImpl sslConfig;
    @Nullable
    protected MqttWebSocketConfigImpl webSocketConfig;
    @NotNull
    protected MqttClientExecutorConfigImpl executorConfig = MqttClientExecutorConfigImpl.DEFAULT;

    protected MqttRxClientBuilderBase() {
    }

    protected MqttRxClientBuilderBase(@NotNull MqttRxClientBuilderBase clientBuilder) {
        this.identifier = clientBuilder.identifier;
        this.serverHost = clientBuilder.serverHost;
        this.serverPort = clientBuilder.serverPort;
        this.customServerPort = clientBuilder.customServerPort;
        this.sslConfig = clientBuilder.sslConfig;
        this.webSocketConfig = clientBuilder.webSocketConfig;
        this.executorConfig = clientBuilder.executorConfig;
    }

    @NotNull
    protected abstract B self();

    @NotNull
    public B identifier(@Nullable String identifier) {
        this.identifier = MqttClientIdentifierImpl.of(identifier);
        return this.self();
    }

    @NotNull
    public B identifier(@Nullable MqttClientIdentifier identifier) {
        this.identifier = MqttChecks.clientIdentifier(identifier);
        return this.self();
    }

    @NotNull
    public B serverHost(@Nullable String host) {
        this.serverHost = Checks.notEmpty(host, "Server host");
        return this.self();
    }

    @NotNull
    public B serverPort(int port) {
        this.serverPort = Checks.unsignedShort(port, "Server port");
        this.customServerPort = true;
        return this.self();
    }

    @NotNull
    public B useSslWithDefaultConfig() {
        return this.useSsl(MqttClientSslConfigImpl.DEFAULT);
    }

    @NotNull
    public B useSsl(@Nullable MqttClientSslConfig sslConfig) {
        if (sslConfig == null) {
            this.sslConfig = null;
            if (!this.customServerPort) {
                this.serverPort = this.webSocketConfig == null ? 1883 : 80;
            }
        } else {
            this.sslConfig = Checks.notImplemented(sslConfig, MqttClientSslConfigImpl.class, "SSL config");
            if (!this.customServerPort) {
                this.serverPort = this.webSocketConfig == null ? 8883 : 443;
            }
        }
        return this.self();
    }

    @NotNull
    public MqttClientSslConfigImplBuilder.Nested<B> useSsl() {
        return new MqttClientSslConfigImplBuilder.Nested<MqttRxClientBuilderBase>(this.sslConfig, this::useSsl);
    }

    @NotNull
    public B useWebSocketWithDefaultConfig() {
        return this.useWebSocket(MqttWebSocketConfigImpl.DEFAULT);
    }

    @NotNull
    public B useWebSocket(@Nullable MqttWebSocketConfig webSocketConfig) {
        if (webSocketConfig == null) {
            this.webSocketConfig = null;
            if (!this.customServerPort) {
                this.serverPort = this.sslConfig == null ? 1883 : 8883;
            }
        } else {
            this.webSocketConfig = Checks.notImplemented(webSocketConfig, MqttWebSocketConfigImpl.class, "WebSocket config");
            if (!this.customServerPort) {
                this.serverPort = this.sslConfig == null ? 80 : 443;
            }
        }
        return this.self();
    }

    @NotNull
    public MqttWebSocketConfigImplBuilder.Nested<B> useWebSocket() {
        return new MqttWebSocketConfigImplBuilder.Nested<MqttRxClientBuilderBase>(this.webSocketConfig, this::useWebSocket);
    }

    @NotNull
    public B executorConfig(@Nullable MqttClientExecutorConfig executorConfig) {
        this.executorConfig = Checks.notImplemented(executorConfig, MqttClientExecutorConfigImpl.class, "Executor config");
        return this.self();
    }

    @NotNull
    public MqttClientExecutorConfigImplBuilder.Nested<B> executorConfig() {
        return new MqttClientExecutorConfigImplBuilder.Nested<MqttRxClientBuilderBase>(this.executorConfig, this::executorConfig);
    }

    public static class Choose
    extends MqttRxClientBuilderBase<Choose>
    implements MqttClientBuilder {
        @Override
        @NotNull
        protected Choose self() {
            return this;
        }

        @Override
        @NotNull
        public Mqtt3RxClientViewBuilder useMqttVersion3() {
            return new Mqtt3RxClientViewBuilder(this);
        }

        @Override
        @NotNull
        public MqttRxClientBuilder useMqttVersion5() {
            return new MqttRxClientBuilder(this);
        }
    }
}

