/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttWebSocketConfigBuilder;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.function.Function;

public abstract class MqttWebSocketConfigImplBuilder<B extends MqttWebSocketConfigImplBuilder<B>> {
    @NotNull
    private String serverPath = "";
    @NotNull
    private String subprotocol = "mqtt";

    MqttWebSocketConfigImplBuilder() {
    }

    MqttWebSocketConfigImplBuilder(@Nullable MqttWebSocketConfigImpl webSocketConfig) {
        if (webSocketConfig != null) {
            this.serverPath = webSocketConfig.getServerPath();
            this.subprotocol = webSocketConfig.getSubprotocol();
        }
    }

    @NotNull
    abstract B self();

    @NotNull
    public B serverPath(@Nullable String serverPath) {
        this.serverPath = Checks.notNull(serverPath, "Server path").replaceAll("^/+", "");
        return this.self();
    }

    @NotNull
    public B subprotocol(@Nullable String subprotocol) {
        this.subprotocol = Checks.notNull(subprotocol, "Subprotocol");
        return this.self();
    }

    @NotNull
    public MqttWebSocketConfigImpl build() {
        return new MqttWebSocketConfigImpl(this.serverPath, this.subprotocol);
    }

    public static class Nested<P>
    extends MqttWebSocketConfigImplBuilder<Nested<P>>
    implements MqttWebSocketConfigBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttWebSocketConfigImpl, P> parentConsumer;

        public Nested(@Nullable MqttWebSocketConfigImpl webSocketConfig, @NotNull Function<? super MqttWebSocketConfigImpl, P> parentConsumer) {
            super(webSocketConfig);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyWebSocketConfig() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttWebSocketConfigImplBuilder<Default>
    implements MqttWebSocketConfigBuilder {
        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

