/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.advanced.interceptor;

import com.hivemq.client.internal.mqtt.advanced.interceptor.MqttClientInterceptors;
import com.hivemq.client.mqtt.mqtt5.advanced.interceptor.Mqtt5ClientInterceptorsBuilder;
import com.hivemq.client.mqtt.mqtt5.advanced.interceptor.qos1.Mqtt5IncomingQos1Interceptor;
import com.hivemq.client.mqtt.mqtt5.advanced.interceptor.qos1.Mqtt5OutgoingQos1Interceptor;
import com.hivemq.client.mqtt.mqtt5.advanced.interceptor.qos2.Mqtt5IncomingQos2Interceptor;
import com.hivemq.client.mqtt.mqtt5.advanced.interceptor.qos2.Mqtt5OutgoingQos2Interceptor;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.function.Function;

public abstract class MqttClientInterceptorsBuilder<B extends MqttClientInterceptorsBuilder<B>> {
    @Nullable
    private Mqtt5IncomingQos1Interceptor incomingQos1Interceptor;
    @Nullable
    private Mqtt5OutgoingQos1Interceptor outgoingQos1Interceptor;
    @Nullable
    private Mqtt5IncomingQos2Interceptor incomingQos2Interceptor;
    @Nullable
    private Mqtt5OutgoingQos2Interceptor outgoingQos2Interceptor;

    MqttClientInterceptorsBuilder() {
    }

    MqttClientInterceptorsBuilder(@Nullable MqttClientInterceptors interceptors) {
        if (interceptors != null) {
            this.incomingQos1Interceptor = interceptors.getIncomingQos1Interceptor();
            this.outgoingQos1Interceptor = interceptors.getOutgoingQos1Interceptor();
            this.incomingQos2Interceptor = interceptors.getIncomingQos2Interceptor();
            this.outgoingQos2Interceptor = interceptors.getOutgoingQos2Interceptor();
        }
    }

    @NotNull
    abstract B self();

    @NotNull
    public B incomingQos1Interceptor(@Nullable Mqtt5IncomingQos1Interceptor incomingQos1Interceptor) {
        this.incomingQos1Interceptor = incomingQos1Interceptor;
        return this.self();
    }

    @NotNull
    public B outgoingQos1Interceptor(@Nullable Mqtt5OutgoingQos1Interceptor outgoingQos1Interceptor) {
        this.outgoingQos1Interceptor = outgoingQos1Interceptor;
        return this.self();
    }

    @NotNull
    public B incomingQos2Interceptor(@Nullable Mqtt5IncomingQos2Interceptor incomingQos2Interceptor) {
        this.incomingQos2Interceptor = incomingQos2Interceptor;
        return this.self();
    }

    @NotNull
    public B outgoingQos2Interceptor(@Nullable Mqtt5OutgoingQos2Interceptor outgoingQos2Interceptor) {
        this.outgoingQos2Interceptor = outgoingQos2Interceptor;
        return this.self();
    }

    @NotNull
    public MqttClientInterceptors build() {
        return new MqttClientInterceptors(this.incomingQos1Interceptor, this.outgoingQos1Interceptor, this.incomingQos2Interceptor, this.outgoingQos2Interceptor);
    }

    public static class Nested<P>
    extends MqttClientInterceptorsBuilder<Nested<P>>
    implements Mqtt5ClientInterceptorsBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttClientInterceptors, P> parentConsumer;

        public Nested(@Nullable MqttClientInterceptors interceptors, @NotNull Function<? super MqttClientInterceptors, P> parentConsumer) {
            super(interceptors);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyInterceptors() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttClientInterceptorsBuilder<Default>
    implements Mqtt5ClientInterceptorsBuilder {
        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

