/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.decoder;

import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderException;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import com.hivemq.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;

public final class MqttMessageDecoderUtil {
    public static void checkFixedHeaderFlags(int expected, int actual) throws MqttDecoderException {
        if (expected != actual) {
            throw new MqttDecoderException("fixed header flags must be " + expected + " but were " + actual);
        }
    }

    public static void checkRemainingLength(int expected, int actual) throws MqttDecoderException {
        if (expected != actual) {
            throw new MqttDecoderException("remaining length must be " + expected + " but was " + actual);
        }
    }

    @NotNull
    public static MqttDecoderException remainingLengthTooShort() {
        return new MqttDecoderException("remaining length too short");
    }

    @NotNull
    public static MqttDecoderException malformedUTF8String(@NotNull String name) {
        return new MqttDecoderException("malformed UTF-8 string for " + name);
    }

    @NotNull
    public static MqttDecoderException malformedTopic() {
        return new MqttDecoderException(Mqtt5DisconnectReasonCode.TOPIC_NAME_INVALID, "malformed topic");
    }

    @NotNull
    public static MqttQos decodePublishQos(int flags, boolean dup) throws MqttDecoderException {
        MqttQos qos = MqttQos.fromCode((flags & 6) >> 1);
        if (qos == null) {
            throw new MqttDecoderException("wrong QoS");
        }
        if (qos == MqttQos.AT_MOST_ONCE && dup) {
            throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "DUP flag must be 0 if QoS is 0");
        }
        return qos;
    }

    public static int decodePublishPacketIdentifier(@NotNull MqttQos qos, @NotNull ByteBuf in) throws MqttDecoderException {
        if (qos == MqttQos.AT_MOST_ONCE) {
            return -1;
        }
        if (in.readableBytes() < 2) {
            throw MqttMessageDecoderUtil.remainingLengthTooShort();
        }
        return in.readUnsignedShort();
    }

    private MqttMessageDecoderUtil() {
    }
}

