/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.decoder.mqtt3;

import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderContext;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderException;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoder;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoderUtil;
import com.hivemq.client.internal.mqtt.message.publish.pubcomp.MqttPubComp;
import com.hivemq.client.internal.mqtt.message.publish.pubcomp.mqtt3.Mqtt3PubCompView;
import com.hivemq.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.shaded.javax.inject.Inject;
import com.hivemq.shaded.javax.inject.Singleton;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;

@Singleton
public class Mqtt3PubCompDecoder
implements MqttMessageDecoder {
    private static final int FLAGS = 0;
    private static final int REMAINING_LENGTH = 2;

    @Inject
    Mqtt3PubCompDecoder() {
    }

    @Override
    @NotNull
    public MqttPubComp decode(int flags, @NotNull ByteBuf in, @NotNull MqttDecoderContext context) throws MqttDecoderException {
        MqttMessageDecoderUtil.checkFixedHeaderFlags(0, flags);
        MqttMessageDecoderUtil.checkRemainingLength(2, in.readableBytes());
        int packetIdentifier = in.readUnsignedShort();
        return Mqtt3PubCompView.delegate(packetIdentifier);
    }
}

