/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.decoder.mqtt3;

import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderContext;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderException;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoder;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoderUtil;
import com.hivemq.client.internal.mqtt.codec.decoder.mqtt3.Mqtt3MessageDecoderUtil;
import com.hivemq.client.internal.mqtt.message.subscribe.suback.MqttSubAck;
import com.hivemq.client.internal.mqtt.message.subscribe.suback.mqtt3.Mqtt3SubAckView;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.suback.Mqtt3SubAckReturnCode;
import com.hivemq.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.shaded.javax.inject.Inject;
import com.hivemq.shaded.javax.inject.Singleton;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;

@Singleton
public class Mqtt3SubAckDecoder
implements MqttMessageDecoder {
    private static final int FLAGS = 0;
    private static final int MIN_REMAINING_LENGTH = 3;

    @Inject
    Mqtt3SubAckDecoder() {
    }

    @Override
    @NotNull
    public MqttSubAck decode(int flags, @NotNull ByteBuf in, @NotNull MqttDecoderContext context) throws MqttDecoderException {
        MqttMessageDecoderUtil.checkFixedHeaderFlags(0, flags);
        if (in.readableBytes() < 3) {
            throw MqttMessageDecoderUtil.remainingLengthTooShort();
        }
        int packetIdentifier = in.readUnsignedShort();
        int returnCodeCount = in.readableBytes();
        ImmutableList.Builder<Mqtt3SubAckReturnCode> returnCodesBuilder = ImmutableList.builder(returnCodeCount);
        for (int i = 0; i < returnCodeCount; ++i) {
            Mqtt3SubAckReturnCode returnCode = Mqtt3SubAckReturnCode.fromCode(in.readUnsignedByte());
            if (returnCode == null) {
                throw Mqtt3MessageDecoderUtil.wrongReturnCode();
            }
            returnCodesBuilder.add(returnCode);
        }
        return Mqtt3SubAckView.delegate(packetIdentifier, returnCodesBuilder.build());
    }
}

