/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.decoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderContext;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderException;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoderUtil;
import com.hivemq.client.internal.mqtt.datatypes.MqttBinaryData;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertyImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import com.hivemq.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.nio.ByteBuffer;

final class Mqtt5MessageDecoderUtil {
    @NotNull
    static MqttDecoderException wrongReasonCode() {
        return new MqttDecoderException("wrong reason code");
    }

    @NotNull
    static MqttDecoderException malformedPropertyLength() {
        return new MqttDecoderException("malformed properties length");
    }

    @NotNull
    static MqttDecoderException wrongProperty(int propertyIdentifier) {
        return new MqttDecoderException("wrong property with identifier " + propertyIdentifier);
    }

    @NotNull
    static MqttDecoderException moreThanOnce(@NotNull String name) {
        return new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, name + " must not be included more than once");
    }

    @NotNull
    static MqttDecoderException noReasonCodes() {
        return new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "must contain at least one reason code");
    }

    static void checkPropertyLengthNoPayload(@NotNull ByteBuf in) throws MqttDecoderException {
        int propertyLength = MqttVariableByteInteger.decode(in);
        if (propertyLength < 0) {
            throw Mqtt5MessageDecoderUtil.malformedPropertyLength();
        }
        if (in.readableBytes() != propertyLength) {
            if (in.readableBytes() < propertyLength) {
                throw MqttMessageDecoderUtil.remainingLengthTooShort();
            }
            throw new MqttDecoderException("must not have a payload");
        }
    }

    static int decodePropertyLength(@NotNull ByteBuf in) throws MqttDecoderException {
        int propertyLength = MqttVariableByteInteger.decode(in);
        if (propertyLength < 0) {
            throw Mqtt5MessageDecoderUtil.malformedPropertyLength();
        }
        if (in.readableBytes() < propertyLength) {
            throw MqttMessageDecoderUtil.remainingLengthTooShort();
        }
        return propertyLength;
    }

    static int decodePropertyIdentifier(@NotNull ByteBuf in) throws MqttDecoderException {
        int propertyIdentifier = MqttVariableByteInteger.decode(in);
        if (propertyIdentifier < 0) {
            throw new MqttDecoderException("malformed property identifier");
        }
        return propertyIdentifier;
    }

    static boolean booleanOnlyOnce(boolean present, @NotNull String name, @NotNull ByteBuf in) throws MqttDecoderException {
        if (present) {
            throw Mqtt5MessageDecoderUtil.moreThanOnce(name);
        }
        if (in.readableBytes() < 1) {
            throw Mqtt5MessageDecoderUtil.malformedPropertyLength();
        }
        byte value = in.readByte();
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "malformed boolean for " + name);
    }

    static short unsignedByteOnlyOnce(boolean present, @NotNull String name, @NotNull ByteBuf in) throws MqttDecoderException {
        if (present) {
            throw Mqtt5MessageDecoderUtil.moreThanOnce(name);
        }
        if (in.readableBytes() < 1) {
            throw Mqtt5MessageDecoderUtil.malformedPropertyLength();
        }
        return in.readUnsignedByte();
    }

    static int unsignedShortOnlyOnce(boolean present, @NotNull String name, @NotNull ByteBuf in) throws MqttDecoderException {
        if (present) {
            throw Mqtt5MessageDecoderUtil.moreThanOnce(name);
        }
        if (in.readableBytes() < 2) {
            throw Mqtt5MessageDecoderUtil.malformedPropertyLength();
        }
        return in.readUnsignedShort();
    }

    static int unsignedShortOnlyOnce(int current, int notPresent, @NotNull String name, @NotNull ByteBuf in) throws MqttDecoderException {
        return Mqtt5MessageDecoderUtil.unsignedShortOnlyOnce(current != notPresent, name, in);
    }

    static long unsignedIntOnlyOnce(boolean present, @NotNull String name, @NotNull ByteBuf in) throws MqttDecoderException {
        if (present) {
            throw Mqtt5MessageDecoderUtil.moreThanOnce(name);
        }
        if (in.readableBytes() < 4) {
            throw Mqtt5MessageDecoderUtil.malformedPropertyLength();
        }
        return in.readUnsignedInt();
    }

    static long unsignedIntOnlyOnce(long current, long notPresent, @NotNull String name, @NotNull ByteBuf in) throws MqttDecoderException {
        return Mqtt5MessageDecoderUtil.unsignedIntOnlyOnce(current != notPresent, name, in);
    }

    @NotNull
    static ByteBuffer decodeBinaryDataOnlyOnce(@Nullable ByteBuffer current, @NotNull String name, @NotNull ByteBuf in, boolean direct) throws MqttDecoderException {
        if (current != null) {
            throw Mqtt5MessageDecoderUtil.moreThanOnce(name);
        }
        ByteBuffer decoded = MqttBinaryData.decode(in, direct);
        if (decoded == null) {
            throw new MqttDecoderException("malformed binary data for " + name);
        }
        return decoded;
    }

    @NotNull
    static MqttUtf8StringImpl decodeUTF8StringOnlyOnce(@Nullable MqttUtf8StringImpl current, @NotNull String name, @NotNull ByteBuf in) throws MqttDecoderException {
        if (current != null) {
            throw Mqtt5MessageDecoderUtil.moreThanOnce(name);
        }
        MqttUtf8StringImpl decoded = MqttUtf8StringImpl.decode(in);
        if (decoded == null) {
            throw MqttMessageDecoderUtil.malformedUTF8String(name);
        }
        return decoded;
    }

    @NotNull
    static MqttUtf8StringImpl decodeReasonString(@Nullable MqttUtf8StringImpl current, @NotNull ByteBuf in) throws MqttDecoderException {
        return Mqtt5MessageDecoderUtil.decodeUTF8StringOnlyOnce(current, "reason string", in);
    }

    @NotNull
    static ImmutableList.Builder<MqttUserPropertyImpl> decodeUserProperty(@Nullable ImmutableList.Builder<MqttUserPropertyImpl> userPropertiesBuilder, @NotNull ByteBuf in) throws MqttDecoderException {
        MqttUserPropertyImpl userProperty = MqttUserPropertyImpl.decode(in);
        if (userProperty == null) {
            throw new MqttDecoderException("malformed user property");
        }
        if (userPropertiesBuilder == null) {
            userPropertiesBuilder = ImmutableList.builder();
        }
        userPropertiesBuilder.add(userProperty);
        return userPropertiesBuilder;
    }

    private static void checkProblemInformationRequested(@NotNull String name, @NotNull MqttDecoderContext context) throws MqttDecoderException {
        if (!context.isProblemInformationRequested()) {
            throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, name + " must not be included if problem information is not requested");
        }
    }

    @NotNull
    static MqttUtf8StringImpl decodeReasonStringIfRequested(@Nullable MqttUtf8StringImpl current, @NotNull ByteBuf in, @NotNull MqttDecoderContext context) throws MqttDecoderException {
        Mqtt5MessageDecoderUtil.checkProblemInformationRequested("reason string", context);
        return Mqtt5MessageDecoderUtil.decodeReasonString(current, in);
    }

    @NotNull
    static ImmutableList.Builder<MqttUserPropertyImpl> decodeUserPropertyIfRequested(@Nullable ImmutableList.Builder<MqttUserPropertyImpl> userPropertiesBuilder, @NotNull ByteBuf in, @NotNull MqttDecoderContext context) throws MqttDecoderException {
        Mqtt5MessageDecoderUtil.checkProblemInformationRequested("user property", context);
        return Mqtt5MessageDecoderUtil.decodeUserProperty(userPropertiesBuilder, in);
    }

    @NotNull
    static MqttUtf8StringImpl decodeAuthMethod(@Nullable MqttUtf8StringImpl current, @NotNull ByteBuf in) throws MqttDecoderException {
        return Mqtt5MessageDecoderUtil.decodeUTF8StringOnlyOnce(current, "auth method", in);
    }

    @NotNull
    static ByteBuffer decodeAuthData(@Nullable ByteBuffer current, @NotNull ByteBuf in, @NotNull MqttDecoderContext context) throws MqttDecoderException {
        return Mqtt5MessageDecoderUtil.decodeBinaryDataOnlyOnce(current, "auth data", in, context.useDirectBufferAuth());
    }

    @NotNull
    static MqttUtf8StringImpl decodeServerReference(@Nullable MqttUtf8StringImpl current, @NotNull ByteBuf in) throws MqttDecoderException {
        return Mqtt5MessageDecoderUtil.decodeUTF8StringOnlyOnce(current, "server reference", in);
    }

    static long decodeSessionExpiryInterval(long current, @NotNull ByteBuf in) throws MqttDecoderException {
        return Mqtt5MessageDecoderUtil.unsignedIntOnlyOnce(current, -1L, "session expiry interval", in);
    }

    private Mqtt5MessageDecoderUtil() {
    }
}

