/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder;

import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttEncoderContext;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttMessageEncoder;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttMessageEncoders;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.MqttMessage;
import com.hivemq.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.shaded.io.netty.buffer.ByteBufAllocator;
import com.hivemq.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import com.hivemq.shaded.io.netty.channel.ChannelPromise;
import com.hivemq.shaded.javax.inject.Inject;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;

@ConnectionScope
public class MqttEncoder
extends ChannelOutboundHandlerAdapter {
    @NotNull
    public static final String NAME = "encoder";
    @NotNull
    private final MqttMessageEncoders encoders;
    @NotNull
    private final MqttEncoderContext context;

    @Inject
    MqttEncoder(@NotNull MqttMessageEncoders encoders) {
        this.encoders = encoders;
        this.context = new MqttEncoderContext(ByteBufAllocator.DEFAULT);
    }

    public void onConnected(@NotNull MqttClientConnectionConfig connectionConfig) {
        this.context.setMaximumPacketSize(connectionConfig.getSendMaximumPacketSize());
    }

    @Override
    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        if (msg instanceof MqttMessage) {
            MqttMessage message = (MqttMessage)msg;
            MqttMessageEncoder messageEncoder = this.encoders.get(message.getType().getCode());
            if (messageEncoder == null) {
                throw new UnsupportedOperationException();
            }
            ByteBuf out = messageEncoder.castAndEncode(message, this.context);
            ctx.write(out, promise);
        } else {
            ctx.write(msg, promise);
        }
    }
}

