/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder.mqtt5;

import com.hivemq.client.internal.mqtt.datatypes.MqttBinaryData;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PayloadFormatIndicator;
import com.hivemq.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.nio.ByteBuffer;

final class Mqtt5MessageEncoderUtil {
    static int propertyEncodedLength(@NotNull MqttUtf8StringImpl string) {
        return 1 + string.encodedLength();
    }

    static int nullablePropertyEncodedLength(@Nullable MqttUtf8StringImpl string) {
        return string == null ? 0 : Mqtt5MessageEncoderUtil.propertyEncodedLength(string);
    }

    static int nullablePropertyEncodedLength(@Nullable ByteBuffer byteBuffer) {
        return byteBuffer == null ? 0 : 1 + MqttBinaryData.encodedLength(byteBuffer);
    }

    static int nullablePropertyEncodedLength(@Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator) {
        return payloadFormatIndicator == null ? 0 : 2;
    }

    static int booleanPropertyEncodedLength(boolean value, boolean defaultValue) {
        return value == defaultValue ? 0 : 2;
    }

    static int shortPropertyEncodedLength(int value, int defaultValue) {
        return value == defaultValue ? 0 : 3;
    }

    static int intPropertyEncodedLength(long value, long defaultValue) {
        return value == defaultValue ? 0 : 5;
    }

    static int variableByteIntegerPropertyEncodedLength(int value) {
        return 1 + MqttVariableByteInteger.encodedLength(value);
    }

    static int variableByteIntegerPropertyEncodedLength(int value, int defaultValue) {
        return value == defaultValue ? 0 : Mqtt5MessageEncoderUtil.variableByteIntegerPropertyEncodedLength(value);
    }

    static void encodeProperty(int propertyIdentifier, @NotNull MqttUtf8StringImpl string, @NotNull ByteBuf out) {
        out.writeByte(propertyIdentifier);
        string.encode(out);
    }

    static void encodeNullableProperty(int propertyIdentifier, @Nullable MqttUtf8StringImpl string, @NotNull ByteBuf out) {
        if (string != null) {
            Mqtt5MessageEncoderUtil.encodeProperty(propertyIdentifier, string, out);
        }
    }

    static void encodeNullableProperty(int propertyIdentifier, @Nullable ByteBuffer byteBuffer, @NotNull ByteBuf out) {
        if (byteBuffer != null) {
            out.writeByte(propertyIdentifier);
            MqttBinaryData.encode(byteBuffer, out);
        }
    }

    static void encodeNullableProperty(int propertyIdentifier, @Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator, @NotNull ByteBuf out) {
        if (payloadFormatIndicator != null) {
            out.writeByte(propertyIdentifier);
            out.writeByte(payloadFormatIndicator.getCode());
        }
    }

    static void encodeBooleanProperty(int propertyIdentifier, boolean value, boolean defaultValue, @NotNull ByteBuf out) {
        if (value != defaultValue) {
            out.writeByte(propertyIdentifier);
            out.writeByte(value ? 1 : 0);
        }
    }

    static void encodeShortProperty(int propertyIdentifier, int value, int defaultValue, @NotNull ByteBuf out) {
        if (value != defaultValue) {
            out.writeByte(propertyIdentifier);
            out.writeShort(value);
        }
    }

    static void encodeIntProperty(int propertyIdentifier, long value, long defaultValue, @NotNull ByteBuf out) {
        if (value != defaultValue) {
            out.writeByte(propertyIdentifier);
            out.writeInt((int)value);
        }
    }

    static void encodeVariableByteIntegerProperty(int propertyIdentifier, int value, @NotNull ByteBuf out) {
        out.writeByte(propertyIdentifier);
        MqttVariableByteInteger.encode(value, out);
    }

    static void encodeVariableByteIntegerProperty(int propertyIdentifier, int value, long defaultValue, @NotNull ByteBuf out) {
        if ((long)value != defaultValue) {
            Mqtt5MessageEncoderUtil.encodeVariableByteIntegerProperty(propertyIdentifier, value, out);
        }
    }

    private Mqtt5MessageEncoderUtil() {
    }
}

