/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.encoder.MqttEncoderContext;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttMessageEncoder;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttMessageEncoderUtil;
import com.hivemq.client.internal.mqtt.codec.encoder.mqtt5.Mqtt5MessageEncoderUtil;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.mqtt.message.MqttMessage;
import com.hivemq.client.internal.mqtt.message.MqttMessageWithUserProperties;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5ReasonCode;
import com.hivemq.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;

abstract class Mqtt5MessageWithUserPropertiesEncoder<M extends MqttMessage.WithUserProperties>
extends MqttMessageEncoder<M> {
    Mqtt5MessageWithUserPropertiesEncoder() {
    }

    @Override
    @NotNull
    protected ByteBuf encode(@NotNull M message, @NotNull MqttEncoderContext context) {
        int propertyLength = this.propertyLength(message);
        int remainingLengthWithoutProperties = this.remainingLengthWithoutProperties(message);
        int remainingLength = this.remainingLength(message, remainingLengthWithoutProperties, propertyLength);
        int encodedLength = MqttMessageEncoderUtil.encodedPacketLength(remainingLength);
        int omittedProperties = 0;
        while (encodedLength > context.getMaximumPacketSize()) {
            if ((propertyLength = this.propertyLength(message, propertyLength, ++omittedProperties)) < 0) {
                throw MqttMessageEncoderUtil.maximumPacketSizeExceeded(message, encodedLength, context.getMaximumPacketSize());
            }
            remainingLength = this.remainingLength(message, remainingLengthWithoutProperties, propertyLength);
            encodedLength = MqttMessageEncoderUtil.encodedPacketLength(remainingLength);
        }
        return this.encode(message, context, encodedLength, remainingLength, propertyLength, omittedProperties);
    }

    @NotNull
    ByteBuf encode(@NotNull M message, @NotNull MqttEncoderContext context, int encodedLength, int remainingLength, int propertyLength, int omittedProperties) {
        ByteBuf out = context.getAllocator().ioBuffer(encodedLength, encodedLength);
        this.encode(message, out, remainingLength, propertyLength, omittedProperties);
        return out;
    }

    abstract void encode(@NotNull M var1, @NotNull ByteBuf var2, int var3, int var4, int var5);

    private int remainingLength(@NotNull M message, int remainingLengthWithoutProperties, int propertyLength) {
        return remainingLengthWithoutProperties + this.propertyLengthWithHeader(message, propertyLength);
    }

    abstract int remainingLengthWithoutProperties(@NotNull M var1);

    abstract int propertyLength(@NotNull M var1);

    int propertyLength(@NotNull M message, int propertyLength, int omittedProperties) {
        switch (omittedProperties) {
            case 0: {
                return propertyLength;
            }
            case 1: {
                return propertyLength - message.getUserProperties().encodedLength();
            }
        }
        return -1;
    }

    int propertyLengthWithHeader(@NotNull M message, int propertyLength) {
        return MqttMessageEncoderUtil.encodedLengthWithHeader(propertyLength);
    }

    int omissiblePropertyLength(@NotNull M message) {
        return message.getUserProperties().encodedLength();
    }

    void encodeOmissibleProperties(@NotNull M message, @NotNull ByteBuf out, int omittedProperties) {
        if (omittedProperties == 0) {
            message.getUserProperties().encode(out);
        }
    }

    static abstract class WithReason<M extends MqttMessageWithUserProperties.WithReason>
    extends Mqtt5MessageWithUserPropertiesEncoder<M> {
        WithReason() {
        }

        @Override
        int propertyLength(@NotNull M message, int propertyLength, int omittedProperties) {
            switch (omittedProperties) {
                case 0: {
                    return propertyLength;
                }
                case 1: {
                    return propertyLength - this.reasonStringLength(message);
                }
                case 2: {
                    return propertyLength - ((MqttMessageWithUserProperties)message).getUserProperties().encodedLength();
                }
            }
            return -1;
        }

        @Override
        final int omissiblePropertyLength(@NotNull M message) {
            return this.reasonStringLength(message) + ((MqttMessageWithUserProperties)message).getUserProperties().encodedLength();
        }

        @Override
        void encodeOmissibleProperties(@NotNull M message, @NotNull ByteBuf out, int omittedProperties) {
            if (omittedProperties == 0) {
                Mqtt5MessageEncoderUtil.encodeNullableProperty(31, ((MqttMessageWithUserProperties.WithReason)message).getRawReasonString(), out);
            }
            if (omittedProperties <= 1) {
                ((MqttMessageWithUserProperties)message).getUserProperties().encode(out);
            }
        }

        private int reasonStringLength(@NotNull M message) {
            return Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(((MqttMessageWithUserProperties.WithReason)message).getRawReasonString());
        }

        static abstract class WithOmissibleCode<M extends MqttMessageWithUserProperties.WithReason.WithCode<R>, R extends Mqtt5ReasonCode>
        extends WithReason<M> {
            WithOmissibleCode() {
            }

            abstract int getFixedHeader();

            @NotNull
            abstract R getDefaultReasonCode();

            @Override
            final int remainingLengthWithoutProperties(@NotNull M message) {
                return 1 + this.additionalRemainingLength(message);
            }

            int additionalRemainingLength(@NotNull M message) {
                return 0;
            }

            @Override
            final int propertyLength(@NotNull M message) {
                return this.omissiblePropertyLength(message) + this.additionalPropertyLength(message);
            }

            int additionalPropertyLength(@NotNull M message) {
                return 0;
            }

            @Override
            protected void encode(@NotNull M message, @NotNull ByteBuf out, int remainingLength, int propertyLength, int omittedProperties) {
                this.encodeFixedHeader(out, remainingLength);
                this.encodeVariableHeader(message, out, propertyLength, omittedProperties);
            }

            private void encodeFixedHeader(@NotNull ByteBuf out, int remainingLength) {
                out.writeByte(this.getFixedHeader());
                MqttVariableByteInteger.encode(remainingLength, out);
            }

            private void encodeVariableHeader(@NotNull M message, @NotNull ByteBuf out, int propertyLength, int omittedProperties) {
                this.encodeAdditionalVariableHeader(message, out);
                Object reasonCode = ((MqttMessageWithUserProperties.WithReason.WithCode)message).getReasonCode();
                if (propertyLength == 0) {
                    if (reasonCode != this.getDefaultReasonCode()) {
                        out.writeByte(reasonCode.getCode());
                    }
                } else {
                    out.writeByte(reasonCode.getCode());
                    MqttVariableByteInteger.encode(propertyLength, out);
                    this.encodeAdditionalProperties(message, out);
                    this.encodeOmissibleProperties(message, out, omittedProperties);
                }
            }

            void encodeAdditionalVariableHeader(@NotNull M message, @NotNull ByteBuf out) {
            }

            void encodeAdditionalProperties(@NotNull M message, @NotNull ByteBuf out) {
            }

            @Override
            final int propertyLengthWithHeader(@NotNull M message, int propertyLength) {
                if (propertyLength == 0) {
                    return ((MqttMessageWithUserProperties.WithReason.WithCode)message).getReasonCode() == this.getDefaultReasonCode() ? -1 : 0;
                }
                return super.propertyLengthWithHeader(message, propertyLength);
            }

            static abstract class WithId<M extends MqttMessageWithUserProperties.WithReason.WithCode.WithId<R>, R extends Mqtt5ReasonCode>
            extends WithOmissibleCode<M, R> {
                WithId() {
                }

                @Override
                int additionalRemainingLength(@NotNull M message) {
                    return 2;
                }

                @Override
                void encodeAdditionalVariableHeader(@NotNull M message, @NotNull ByteBuf out) {
                    out.writeShort(((MqttMessageWithUserProperties.WithReason.WithCode.WithId)message).getPacketIdentifier());
                }
            }
        }
    }
}

