/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.encoder.MqttEncoderContext;
import com.hivemq.client.internal.mqtt.codec.encoder.mqtt5.Mqtt5MessageEncoderUtil;
import com.hivemq.client.internal.mqtt.codec.encoder.mqtt5.Mqtt5MessageWithUserPropertiesEncoder;
import com.hivemq.client.internal.mqtt.datatypes.MqttBinaryData;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttStatefulPublish;
import com.hivemq.client.internal.util.collections.ImmutableIntList;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5MessageType;
import com.hivemq.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.shaded.io.netty.buffer.Unpooled;
import com.hivemq.shaded.javax.inject.Inject;
import com.hivemq.shaded.javax.inject.Singleton;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import java.nio.ByteBuffer;

@Singleton
public class Mqtt5PublishEncoder
extends Mqtt5MessageWithUserPropertiesEncoder<MqttStatefulPublish> {
    private static final int FIXED_HEADER = Mqtt5MessageType.PUBLISH.getCode() << 4;

    @Inject
    Mqtt5PublishEncoder() {
    }

    @Override
    int remainingLengthWithoutProperties(@NotNull MqttStatefulPublish message) {
        ByteBuffer payload;
        MqttPublish stateless = (MqttPublish)message.stateless();
        int remainingLength = 0;
        remainingLength = message.getTopicAlias() == 0 || message.isNewTopicAlias() ? (remainingLength += stateless.getTopic().encodedLength()) : 2;
        if (stateless.getQos() != MqttQos.AT_MOST_ONCE) {
            remainingLength += 2;
        }
        if ((payload = stateless.getRawPayload()) != null) {
            remainingLength += payload.remaining();
        }
        return remainingLength;
    }

    @Override
    int propertyLength(@NotNull MqttStatefulPublish message) {
        int propertyLength = 0;
        propertyLength += this.fixedPropertyLength((MqttPublish)message.stateless());
        propertyLength += this.omissiblePropertyLength(message);
        propertyLength += Mqtt5MessageEncoderUtil.shortPropertyEncodedLength(message.getTopicAlias(), 0);
        ImmutableIntList subscriptionIdentifiers = message.getSubscriptionIdentifiers();
        for (int i = 0; i < subscriptionIdentifiers.size(); ++i) {
            propertyLength += Mqtt5MessageEncoderUtil.variableByteIntegerPropertyEncodedLength(subscriptionIdentifiers.get(i));
        }
        return propertyLength;
    }

    final int fixedPropertyLength(@NotNull MqttPublish publish) {
        int propertyLength = 0;
        propertyLength += Mqtt5MessageEncoderUtil.intPropertyEncodedLength(publish.getRawMessageExpiryInterval(), Long.MAX_VALUE);
        propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(publish.getRawPayloadFormatIndicator());
        propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(publish.getRawContentType());
        propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(publish.getRawResponseTopic());
        return propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(publish.getRawCorrelationData());
    }

    @Override
    @NotNull
    ByteBuf encode(@NotNull MqttStatefulPublish message, @NotNull MqttEncoderContext context, int encodedLength, int remainingLength, int propertyLength, int omittedProperties) {
        ByteBuffer payload = ((MqttPublish)message.stateless()).getRawPayload();
        if (payload != null && payload.isDirect()) {
            int encodedLengthWithoutPayload = encodedLength - payload.remaining();
            ByteBuf out = context.getAllocator().ioBuffer(encodedLengthWithoutPayload, encodedLengthWithoutPayload);
            this.encode(message, out, remainingLength, propertyLength, omittedProperties);
            return Unpooled.wrappedUnmodifiableBuffer(out, Unpooled.wrappedBuffer(payload));
        }
        ByteBuf out = context.getAllocator().ioBuffer(encodedLength, encodedLength);
        this.encode(message, out, remainingLength, propertyLength, omittedProperties);
        return out;
    }

    @Override
    void encode(@NotNull MqttStatefulPublish message, @NotNull ByteBuf out, int remainingLength, int propertyLength, int omittedProperties) {
        this.encodeFixedHeader(message, out, remainingLength);
        this.encodeVariableHeader(message, out, propertyLength, omittedProperties);
        this.encodePayload(message, out);
    }

    private void encodeFixedHeader(@NotNull MqttStatefulPublish message, @NotNull ByteBuf out, int remainingLength) {
        MqttPublish stateless = (MqttPublish)message.stateless();
        int flags = 0;
        if (message.isDup()) {
            flags |= 8;
        }
        flags |= stateless.getQos().getCode() << 1;
        if (stateless.isRetain()) {
            flags |= 1;
        }
        out.writeByte(FIXED_HEADER | flags);
        MqttVariableByteInteger.encode(remainingLength, out);
    }

    private void encodeVariableHeader(@NotNull MqttStatefulPublish message, @NotNull ByteBuf out, int propertyLength, int omittedProperties) {
        MqttPublish stateless = (MqttPublish)message.stateless();
        if (message.getTopicAlias() == 0 || message.isNewTopicAlias()) {
            stateless.getTopic().encode(out);
        } else {
            MqttBinaryData.encodeEmpty(out);
        }
        if (stateless.getQos() != MqttQos.AT_MOST_ONCE) {
            out.writeShort(message.getPacketIdentifier());
        }
        this.encodeProperties(message, out, propertyLength, omittedProperties);
    }

    private void encodeProperties(@NotNull MqttStatefulPublish message, @NotNull ByteBuf out, int propertyLength, int omittedProperties) {
        MqttVariableByteInteger.encode(propertyLength, out);
        this.encodeFixedProperties((MqttPublish)message.stateless(), out);
        this.encodeOmissibleProperties(message, out, omittedProperties);
        Mqtt5MessageEncoderUtil.encodeShortProperty(35, message.getTopicAlias(), 0, out);
        ImmutableIntList subscriptionIdentifiers = message.getSubscriptionIdentifiers();
        for (int i = 0; i < subscriptionIdentifiers.size(); ++i) {
            Mqtt5MessageEncoderUtil.encodeVariableByteIntegerProperty(11, subscriptionIdentifiers.get(i), out);
        }
    }

    final void encodeFixedProperties(@NotNull MqttPublish publish, @NotNull ByteBuf out) {
        Mqtt5MessageEncoderUtil.encodeIntProperty(2, publish.getRawMessageExpiryInterval(), Long.MAX_VALUE, out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(1, publish.getRawPayloadFormatIndicator(), out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(3, publish.getRawContentType(), out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(8, publish.getRawResponseTopic(), out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(9, publish.getRawCorrelationData(), out);
    }

    private void encodePayload(@NotNull MqttStatefulPublish message, @NotNull ByteBuf out) {
        ByteBuffer payload = ((MqttPublish)message.stateless()).getRawPayload();
        if (payload != null && !payload.isDirect()) {
            out.writeBytes(payload.duplicate());
        }
    }
}

