/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.encoder.mqtt5.Mqtt5MessageEncoderUtil;
import com.hivemq.client.internal.mqtt.codec.encoder.mqtt5.Mqtt5MessageWithUserPropertiesEncoder;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttStatefulSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5MessageType;
import com.hivemq.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.shaded.javax.inject.Inject;
import com.hivemq.shaded.javax.inject.Singleton;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import java.util.List;

@Singleton
public class Mqtt5SubscribeEncoder
extends Mqtt5MessageWithUserPropertiesEncoder<MqttStatefulSubscribe> {
    private static final int FIXED_HEADER = Mqtt5MessageType.SUBSCRIBE.getCode() << 4 | 2;
    private static final int VARIABLE_HEADER_FIXED_LENGTH = 2;

    @Inject
    Mqtt5SubscribeEncoder() {
    }

    @Override
    int remainingLengthWithoutProperties(@NotNull MqttStatefulSubscribe message) {
        int remainingLength = 2;
        List subscriptions = ((MqttSubscribe)message.stateless()).getSubscriptions();
        for (int i = 0; i < subscriptions.size(); ++i) {
            remainingLength += ((MqttSubscription)subscriptions.get(i)).getTopicFilter().encodedLength() + 1;
        }
        return remainingLength;
    }

    @Override
    int propertyLength(@NotNull MqttStatefulSubscribe message) {
        int propertyLength = 0;
        propertyLength += this.omissiblePropertyLength(message);
        return propertyLength += Mqtt5MessageEncoderUtil.variableByteIntegerPropertyEncodedLength(message.getSubscriptionIdentifier(), -1);
    }

    @Override
    void encode(@NotNull MqttStatefulSubscribe message, @NotNull ByteBuf out, int remainingLength, int propertyLength, int omittedProperties) {
        this.encodeFixedHeader(out, remainingLength);
        this.encodeVariableHeader(message, out, propertyLength, omittedProperties);
        this.encodePayload(message, out);
    }

    private void encodeFixedHeader(@NotNull ByteBuf out, int remainingLength) {
        out.writeByte(FIXED_HEADER);
        MqttVariableByteInteger.encode(remainingLength, out);
    }

    private void encodeVariableHeader(@NotNull MqttStatefulSubscribe message, @NotNull ByteBuf out, int propertyLength, int omittedProperties) {
        out.writeShort(message.getPacketIdentifier());
        this.encodeProperties(message, out, propertyLength, omittedProperties);
    }

    private void encodeProperties(@NotNull MqttStatefulSubscribe message, @NotNull ByteBuf out, int propertyLength, int omittedProperties) {
        MqttVariableByteInteger.encode(propertyLength, out);
        Mqtt5MessageEncoderUtil.encodeVariableByteIntegerProperty(11, message.getSubscriptionIdentifier(), -1L, out);
        this.encodeOmissibleProperties(message, out, omittedProperties);
    }

    private void encodePayload(@NotNull MqttStatefulSubscribe message, @NotNull ByteBuf out) {
        List subscriptions = ((MqttSubscribe)message.stateless()).getSubscriptions();
        for (int i = 0; i < subscriptions.size(); ++i) {
            MqttSubscription subscription = (MqttSubscription)subscriptions.get(i);
            subscription.getTopicFilter().encode(out);
            int subscriptionOptions = 0;
            subscriptionOptions |= subscription.getRetainHandling().getCode() << 4;
            if (subscription.isRetainAsPublished()) {
                subscriptionOptions |= 8;
            }
            if (subscription.isNoLocal()) {
                subscriptionOptions |= 4;
            }
            out.writeByte(subscriptionOptions |= subscription.getQos().getCode());
        }
    }
}

