/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttBinaryData;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.datatypes.MqttTopic;
import com.hivemq.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.shaded.org.jetbrains.annotations.Contract;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;

@Immutable
public class MqttTopicImpl
extends MqttUtf8StringImpl
implements MqttTopic {
    @Contract(value="null -> fail")
    @NotNull
    public static MqttTopicImpl of(@Nullable String string) {
        return MqttTopicImpl.of(string, "Topic");
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static MqttTopicImpl of(@Nullable String string, @NotNull String name) {
        Checks.notEmpty(string, name);
        MqttTopicImpl.checkLength(string, name);
        MqttTopicImpl.checkWellFormed(string, name);
        return new MqttTopicImpl(string);
    }

    @Nullable
    public static MqttTopicImpl of(@NotNull byte[] binary) {
        return binary.length == 0 || !MqttBinaryData.isInRange(binary) || MqttTopicImpl.isWellFormed(binary) ? null : new MqttTopicImpl(binary);
    }

    @Nullable
    public static MqttTopicImpl decode(@NotNull ByteBuf byteBuf) {
        byte[] binary = MqttBinaryData.decode(byteBuf);
        return binary == null ? null : MqttTopicImpl.of(binary);
    }

    static boolean isWellFormed(@NotNull byte[] binary) {
        return MqttUtf8StringImpl.isWellFormed(binary) || MqttTopicImpl.containsWildcardCharacters(binary);
    }

    static void checkWellFormed(@NotNull String string, @NotNull String name) {
        MqttUtf8StringImpl.checkWellFormed(string, name);
        MqttTopicImpl.checkNoWildcardCharacters(string, name);
    }

    private static boolean containsWildcardCharacters(@NotNull byte[] binary) {
        for (byte b : binary) {
            if (b != 35 && b != 43) continue;
            return true;
        }
        return false;
    }

    private static void checkNoWildcardCharacters(@NotNull String string, @NotNull String name) {
        int multiLevelIndex = string.indexOf(35);
        if (multiLevelIndex != -1) {
            throw new IllegalArgumentException(name + " [" + string + "] must not contain multi level wildcard (" + '#' + "), found at index " + multiLevelIndex + ".");
        }
        int singleLevelIndex = string.indexOf(43);
        if (singleLevelIndex != -1) {
            throw new IllegalArgumentException(name + " [" + string + "] must not contain single level wildcard (" + '+' + "), found at index " + singleLevelIndex + ".");
        }
    }

    @NotNull
    static ImmutableList<String> splitLevels(@NotNull String string) {
        ImmutableList.Builder<String> levelsBuilder = ImmutableList.builder();
        int start = 0;
        while (true) {
            int end;
            if ((end = string.indexOf(47, start)) == -1) {
                levelsBuilder.add(string.substring(start));
                return levelsBuilder.build();
            }
            levelsBuilder.add(string.substring(start, end));
            start = end + 1;
        }
    }

    private MqttTopicImpl(@NotNull byte[] binary) {
        super(binary);
    }

    private MqttTopicImpl(@NotNull String string) {
        super(string);
    }

    @NotNull
    public ImmutableList<String> getLevels() {
        return MqttTopicImpl.splitLevels(this.toString());
    }

    @Override
    @NotNull
    public MqttTopicFilterImpl filter() {
        return MqttTopicFilterImpl.of(this);
    }

    @Override
    @NotNull
    public MqttTopicImplBuilder.Default extend() {
        return new MqttTopicImplBuilder.Default(this);
    }
}

