/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertyImpl;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperties;
import com.hivemq.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;

@Immutable
public class MqttUserPropertiesImpl
implements Mqtt5UserProperties {
    @NotNull
    public static final MqttUserPropertiesImpl NO_USER_PROPERTIES = new MqttUserPropertiesImpl(ImmutableList.of());
    @NotNull
    private final ImmutableList<MqttUserPropertyImpl> userProperties;
    private int encodedLength = -1;

    @NotNull
    public static MqttUserPropertiesImpl of(@NotNull ImmutableList<MqttUserPropertyImpl> userProperties) {
        return userProperties.isEmpty() ? NO_USER_PROPERTIES : new MqttUserPropertiesImpl(userProperties);
    }

    @NotNull
    public static MqttUserPropertiesImpl build(@Nullable ImmutableList.Builder<MqttUserPropertyImpl> userPropertiesBuilder) {
        return userPropertiesBuilder == null ? NO_USER_PROPERTIES : MqttUserPropertiesImpl.of(userPropertiesBuilder.build());
    }

    private MqttUserPropertiesImpl(@NotNull ImmutableList<MqttUserPropertyImpl> userProperties) {
        this.userProperties = userProperties;
    }

    @NotNull
    public ImmutableList<MqttUserPropertyImpl> asList() {
        return this.userProperties;
    }

    public void encode(@NotNull ByteBuf out) {
        for (int i = 0; i < this.userProperties.size(); ++i) {
            this.userProperties.get(i).encode(out);
        }
    }

    public int encodedLength() {
        if (this.encodedLength == -1) {
            this.encodedLength = this.calculateEncodedLength();
        }
        return this.encodedLength;
    }

    private int calculateEncodedLength() {
        int encodedLength = 0;
        for (int i = 0; i < this.userProperties.size(); ++i) {
            encodedLength += this.userProperties.get(i).encodedLength();
        }
        return encodedLength;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttUserPropertiesImpl)) {
            return false;
        }
        MqttUserPropertiesImpl that = (MqttUserPropertiesImpl)o;
        return this.userProperties.equals(that.userProperties);
    }

    public int hashCode() {
        return this.userProperties.hashCode();
    }

    @Override
    @NotNull
    public MqttUserPropertiesImplBuilder.Default extend() {
        return new MqttUserPropertiesImplBuilder.Default(this);
    }

    @NotNull
    public String toString() {
        return this.userProperties.toString();
    }
}

