/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttEncoder;
import com.hivemq.client.internal.mqtt.handler.auth.MqttAuthHandler;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckFlow;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckSingle;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnectHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectHandler;
import com.hivemq.client.internal.mqtt.handler.ssl.SslUtil;
import com.hivemq.client.internal.mqtt.handler.websocket.MqttWebSocketInitializer;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.mqtt.MqttWebSocketConfig;
import com.hivemq.shaded.dagger.Lazy;
import com.hivemq.shaded.io.netty.channel.Channel;
import com.hivemq.shaded.io.netty.channel.ChannelHandler;
import com.hivemq.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.shaded.io.netty.channel.ChannelInitializer;
import com.hivemq.shaded.javax.inject.Inject;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import java.net.URISyntaxException;
import javax.net.ssl.SSLException;

@ConnectionScope
public class MqttChannelInitializer
extends ChannelInitializer<Channel> {
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttConnAckFlow connAckFlow;
    @NotNull
    private final MqttEncoder encoder;
    @NotNull
    private final MqttConnectHandler connectHandler;
    @NotNull
    private final MqttDisconnectHandler disconnectHandler;
    @NotNull
    private final MqttAuthHandler authHandler;
    @NotNull
    private final Lazy<MqttWebSocketInitializer> webSocketInitializer;

    @Inject
    MqttChannelInitializer(@NotNull MqttClientConfig clientConfig, @NotNull MqttConnAckFlow connAckFlow, @NotNull MqttEncoder encoder, @NotNull MqttConnectHandler connectHandler, @NotNull MqttDisconnectHandler disconnectHandler, @NotNull MqttAuthHandler authHandler, @NotNull Lazy<MqttWebSocketInitializer> webSocketInitializer) {
        this.clientConfig = clientConfig;
        this.connAckFlow = connAckFlow;
        this.encoder = encoder;
        this.connectHandler = connectHandler;
        this.disconnectHandler = disconnectHandler;
        this.authHandler = authHandler;
        this.webSocketInitializer = webSocketInitializer;
    }

    @Override
    protected void initChannel(@NotNull Channel channel) throws Exception {
        MqttWebSocketConfigImpl webSocketConfig;
        MqttClientSslConfigImpl sslConfig = this.clientConfig.getRawSslConfig();
        if (sslConfig != null) {
            this.initSsl(channel, sslConfig);
        }
        if ((webSocketConfig = this.clientConfig.getRawWebSocketConfig()) != null) {
            this.initWebSocketMqtt(channel, webSocketConfig);
        } else {
            this.initMqtt(channel);
        }
    }

    public void initMqtt(@NotNull Channel channel) {
        channel.pipeline().addLast("encoder", (ChannelHandler)this.encoder).addLast("auth", (ChannelHandler)this.authHandler).addLast("connect", (ChannelHandler)this.connectHandler).addLast("disconnect", (ChannelHandler)this.disconnectHandler);
    }

    private void initWebSocketMqtt(@NotNull Channel channel, @NotNull MqttWebSocketConfig webSocketConfig) throws URISyntaxException {
        this.webSocketInitializer.get().initChannel(channel, webSocketConfig);
    }

    private void initSsl(@NotNull Channel channel, @NotNull MqttClientSslConfigImpl sslConfig) throws SSLException {
        SslUtil.initChannel(channel, sslConfig);
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        if (ctx.pipeline().get("disconnect") != null) {
            ctx.pipeline().remove("disconnect");
        }
        ctx.close();
        MqttConnAckSingle.onError(this.clientConfig, this.connAckFlow, cause);
        this.clientConfig.releaseEventLoop();
    }
}

