/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler;

import com.hivemq.client.internal.annotations.CallByThread;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingQosHandler;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttOutgoingQosHandler;
import com.hivemq.client.internal.mqtt.handler.subscribe.MqttSubscriptionHandler;
import com.hivemq.client.internal.mqtt.ioc.ClientScope;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAck;
import com.hivemq.client.mqtt.exceptions.MqttSessionExpiredException;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5ConnAckException;
import com.hivemq.shaded.io.netty.channel.ChannelPipeline;
import com.hivemq.shaded.io.netty.channel.EventLoop;
import com.hivemq.shaded.io.netty.util.concurrent.ScheduledFuture;
import com.hivemq.shaded.javax.inject.Inject;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.concurrent.TimeUnit;

@ClientScope
public class MqttSession {
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttSubscriptionHandler subscriptionHandler;
    @NotNull
    private final MqttIncomingQosHandler incomingQosHandler;
    @NotNull
    private final MqttOutgoingQosHandler outgoingQosHandler;
    private boolean hasSession;
    @Nullable
    private ScheduledFuture<?> expireFuture;

    @Inject
    MqttSession(@NotNull MqttClientConfig clientConfig, @NotNull MqttSubscriptionHandler subscriptionHandler, @NotNull MqttIncomingQosHandler incomingQosHandler, @NotNull MqttOutgoingQosHandler outgoingQosHandler) {
        this.clientConfig = clientConfig;
        this.subscriptionHandler = subscriptionHandler;
        this.incomingQosHandler = incomingQosHandler;
        this.outgoingQosHandler = outgoingQosHandler;
    }

    @CallByThread(value="Netty EventLoop")
    public void startOrResume(@NotNull MqttConnAck connAck, @NotNull ChannelPipeline pipeline, @NotNull MqttClientConnectionConfig connectionConfig) {
        if (this.hasSession && !connAck.isSessionPresent()) {
            String message = "Session expired as CONNACK did not contain the session present flag.";
            this.end(new MqttSessionExpiredException("Session expired as CONNACK did not contain the session present flag.", new Mqtt5ConnAckException(connAck, "Session expired as CONNACK did not contain the session present flag.")));
        }
        this.hasSession = true;
        if (this.expireFuture != null) {
            this.expireFuture.cancel(false);
            this.expireFuture = null;
        }
        pipeline.addAfter("decoder", "subscription", this.subscriptionHandler);
        pipeline.addAfter("decoder", "qos.incoming", this.incomingQosHandler);
        pipeline.addAfter("decoder", "qos.outgoing", this.outgoingQosHandler);
        this.subscriptionHandler.onSessionStartOrResume(connectionConfig);
        this.incomingQosHandler.onSessionStartOrResume(connectionConfig);
        this.outgoingQosHandler.onSessionStartOrResume(connectionConfig);
    }

    @CallByThread(value="Netty EventLoop")
    public void expire(@NotNull Throwable cause, @NotNull EventLoop eventLoop) {
        MqttClientConnectionConfig connectionConfig = this.clientConfig.getRawConnectionConfig();
        if (connectionConfig != null) {
            long expiryInterval = connectionConfig.getSessionExpiryInterval();
            if (expiryInterval == 0L) {
                eventLoop.execute(() -> this.end(new MqttSessionExpiredException("Session expired as connection was closed.", cause)));
            } else if (expiryInterval != 0xFFFFFFFFL) {
                this.expireFuture = eventLoop.schedule(() -> {
                    if (this.expireFuture != null) {
                        this.expireFuture = null;
                        this.end(new MqttSessionExpiredException("Session expired after expiry interval", cause));
                    }
                }, (long)((double)TimeUnit.SECONDS.toMillis(expiryInterval) * 1.1), TimeUnit.MILLISECONDS);
            }
        }
    }

    @CallByThread(value="Netty EventLoop")
    private void end(@NotNull Throwable cause) {
        if (this.hasSession) {
            this.hasSession = false;
            this.outgoingQosHandler.onSessionEnd(cause);
            this.incomingQosHandler.onSessionEnd(cause);
            this.subscriptionHandler.onSessionEnd(cause);
        }
    }
}

