/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.auth;

import com.hivemq.client.internal.mqtt.handler.auth.MqttAuthHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.message.auth.MqttAuth;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAck;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5AuthException;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5ConnAckException;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import com.hivemq.shaded.io.netty.channel.ChannelHandler;
import com.hivemq.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import com.hivemq.shaded.javax.inject.Inject;
import com.hivemq.shaded.javax.inject.Singleton;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
@Singleton
public class MqttDisconnectOnAuthHandler
extends ChannelInboundHandlerAdapter
implements MqttAuthHandler {
    @Inject
    MqttDisconnectOnAuthHandler() {
    }

    @Override
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof MqttAuth) {
            this.readAuth(ctx, (MqttAuth)msg);
        } else if (msg instanceof MqttConnAck) {
            this.readConnAck(ctx, (MqttConnAck)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void readAuth(@NotNull ChannelHandlerContext ctx, @NotNull MqttAuth auth) {
        MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5AuthException(auth, "Server must not send AUTH"));
    }

    private void readConnAck(@NotNull ChannelHandlerContext ctx, @NotNull MqttConnAck connAck) {
        if (connAck.getRawEnhancedAuth() != null) {
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5ConnAckException(connAck, "Server must not include auth in CONNACK"));
        } else {
            ctx.fireChannelRead(connAck);
        }
    }

    @Override
    public boolean isSharable() {
        return true;
    }
}

