/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.connect;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckFlow;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.mqtt.MqttClientState;
import com.hivemq.client.mqtt.exceptions.ConnectionFailedException;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import com.hivemq.shaded.io.netty.bootstrap.Bootstrap;
import com.hivemq.shaded.io.netty.util.concurrent.Future;
import com.hivemq.shaded.io.netty.util.concurrent.GenericFutureListener;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;

public class MqttConnAckSingle
extends Single<Mqtt5ConnAck> {
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttConnect connect;

    public MqttConnAckSingle(@NotNull MqttClientConfig clientConfig, @NotNull MqttConnect connect) {
        this.clientConfig = clientConfig;
        this.connect = connect;
    }

    protected void subscribeActual(@NotNull SingleObserver<? super Mqtt5ConnAck> observer) {
        if (!this.clientConfig.getRawState().compareAndSet(MqttClientState.DISCONNECTED, MqttClientState.CONNECTING)) {
            EmptyDisposable.error((Throwable)MqttClientStateExceptions.alreadyConnected(), observer);
            return;
        }
        MqttConnAckFlow flow = new MqttConnAckFlow(observer);
        observer.onSubscribe((Disposable)flow);
        Bootstrap bootstrap = this.clientConfig.getClientComponent().connectionComponentBuilder().connect(this.connect).connAckFlow(flow).build().bootstrap();
        bootstrap.connect(this.clientConfig.getServerHost(), this.clientConfig.getServerPort()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (!future.isSuccess()) {
                MqttConnAckSingle.onError(this.clientConfig, flow, future.cause());
            }
        }));
    }

    public static void onError(@NotNull MqttClientConfig clientConfig, @NotNull MqttConnAckFlow flow, @NotNull Throwable cause) {
        if (flow.onError(new ConnectionFailedException(cause))) {
            clientConfig.getRawState().set(MqttClientState.DISCONNECTED);
        }
    }
}

