/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.connect;

import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoder;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttEncoder;
import com.hivemq.client.internal.mqtt.datatypes.MqttClientIdentifierImpl;
import com.hivemq.client.internal.mqtt.handler.MqttSession;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckFlow;
import com.hivemq.client.internal.mqtt.handler.connect.MqttDisconnectOnConnAckHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectEvent;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.handler.ping.MqttPingHandler;
import com.hivemq.client.internal.mqtt.handler.util.MqttTimeoutInboundHandler;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.MqttMessage;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictions;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAck;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAckRestrictions;
import com.hivemq.client.mqtt.MqttClientState;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5ConnAckException;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAckReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import com.hivemq.shaded.io.netty.channel.Channel;
import com.hivemq.shaded.io.netty.channel.ChannelFuture;
import com.hivemq.shaded.io.netty.channel.ChannelHandler;
import com.hivemq.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.shaded.javax.inject.Inject;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;

@ConnectionScope
public class MqttConnectHandler
extends MqttTimeoutInboundHandler {
    @NotNull
    public static final String NAME = "connect";
    @NotNull
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(MqttConnectHandler.class);
    private static final int CONNACK_TIMEOUT = 60;
    @NotNull
    private final MqttConnect connect;
    @NotNull
    private final MqttConnAckFlow connAckFlow;
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttSession session;
    @NotNull
    private final MqttDecoder decoder;
    @NotNull
    private final MqttDisconnectOnConnAckHandler disconnectOnConnAckHandler;
    private boolean connectCalled = false;

    @Inject
    MqttConnectHandler(@NotNull MqttConnect connect, @NotNull MqttConnAckFlow connAckFlow, @NotNull MqttClientConfig clientConfig, @NotNull MqttSession session, @NotNull MqttDecoder decoder, @NotNull MqttDisconnectOnConnAckHandler disconnectOnConnAckHandler) {
        this.connect = connect;
        this.connAckFlow = connAckFlow;
        this.clientConfig = clientConfig;
        this.session = session;
        this.decoder = decoder;
        this.disconnectOnConnAckHandler = disconnectOnConnAckHandler;
    }

    @Override
    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        if (!this.connectCalled) {
            this.connectCalled = true;
            this.writeConnect(ctx);
        }
        ctx.fireChannelActive();
    }

    @Override
    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        if (!this.connectCalled && ctx.channel().isActive()) {
            this.connectCalled = true;
            this.writeConnect(ctx);
        }
    }

    private void writeConnect(@NotNull ChannelHandlerContext ctx) {
        ctx.writeAndFlush(this.connect.getRawEnhancedAuthMechanism() == null ? this.connect.createStateful(this.clientConfig.getRawClientIdentifier(), null) : this.connect).addListener(this);
    }

    @Override
    public void operationComplete(@NotNull ChannelFuture future) {
        if (this.ctx == null) {
            return;
        }
        if (future.isSuccess()) {
            if (this.connect.getRawEnhancedAuthMechanism() == null) {
                this.scheduleTimeout(this.ctx.channel());
            }
            this.ctx.pipeline().addAfter("encoder", "decoder", this.decoder);
        }
    }

    @Override
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        this.cancelTimeout();
        if (msg instanceof MqttConnAck) {
            this.readConnAck((MqttConnAck)msg, ctx.channel());
        } else {
            this.readOtherThanConnAck(msg, ctx.channel());
        }
    }

    private void readConnAck(@NotNull MqttConnAck connAck, @NotNull Channel channel) {
        if (((Mqtt5ConnAckReasonCode)connAck.getReasonCode()).isError()) {
            MqttDisconnectUtil.close(channel, new Mqtt5ConnAckException(connAck, "CONNECT failed as CONNACK contained an Error Code: " + connAck.getReasonCode() + "."));
        } else if (this.validateClientIdentifier(connAck, channel)) {
            MqttClientConnectionConfig connectionConfig = this.addConnectionConfig(connAck, channel);
            channel.pipeline().remove(this).addLast("disconnect.on.connack", (ChannelHandler)this.disconnectOnConnAckHandler);
            ((MqttEncoder)channel.pipeline().get("encoder")).onConnected(connectionConfig);
            this.session.startOrResume(connAck, channel.pipeline(), connectionConfig);
            int keepAlive = connectionConfig.getKeepAlive();
            if (keepAlive > 0) {
                channel.pipeline().addAfter("decoder", "ping", new MqttPingHandler(keepAlive));
            }
            this.clientConfig.getRawState().set(MqttClientState.CONNECTED);
            this.connAckFlow.onSuccess(connAck);
        }
    }

    private void readOtherThanConnAck(@NotNull Object msg, @NotNull Channel channel) {
        if (msg instanceof MqttMessage) {
            MqttDisconnectUtil.disconnect(channel, Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, (Object)((Object)((MqttMessage)msg).getType()) + " message must not be received before CONNACK");
        } else {
            MqttDisconnectUtil.close(channel, "No data must be received before CONNECT is sent");
        }
    }

    private boolean validateClientIdentifier(@NotNull MqttConnAck connAck, @NotNull Channel channel) {
        MqttClientIdentifierImpl clientIdentifier = this.clientConfig.getRawClientIdentifier();
        MqttClientIdentifierImpl assignedClientIdentifier = connAck.getRawAssignedClientIdentifier();
        if (clientIdentifier == MqttClientIdentifierImpl.REQUEST_CLIENT_IDENTIFIER_FROM_SERVER) {
            if (this.clientConfig.getMqttVersion() == MqttVersion.MQTT_5_0 && assignedClientIdentifier == null) {
                MqttDisconnectUtil.disconnect(channel, Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5ConnAckException(connAck, "Server did not assign a Client Identifier"));
                return false;
            }
        } else if (assignedClientIdentifier != null) {
            LOGGER.warn("Server overwrote the Client Identifier {} with {}", clientIdentifier, assignedClientIdentifier);
        }
        if (assignedClientIdentifier != null) {
            this.clientConfig.setClientIdentifier(assignedClientIdentifier);
        }
        return true;
    }

    @NotNull
    private MqttClientConnectionConfig addConnectionConfig(@NotNull MqttConnAck connAck, @NotNull Channel channel) {
        long sessionExpiryInterval;
        int keepAlive = connAck.getRawServerKeepAlive();
        if (keepAlive == -1) {
            keepAlive = this.connect.getKeepAlive();
        }
        if ((sessionExpiryInterval = connAck.getRawSessionExpiryInterval()) == -1L) {
            sessionExpiryInterval = this.connect.getSessionExpiryInterval();
        }
        MqttConnectRestrictions restrictions = this.connect.getRestrictions();
        MqttConnAckRestrictions connAckRestrictions = connAck.getRestrictions();
        MqttClientConnectionConfig connectionConfig = new MqttClientConnectionConfig(keepAlive, sessionExpiryInterval, this.connect.getRawWillPublish() != null, this.connect.getRawEnhancedAuthMechanism(), restrictions.getReceiveMaximum(), restrictions.getMaximumPacketSize(), restrictions.getTopicAliasMaximum(), restrictions.isRequestProblemInformation(), restrictions.isRequestResponseInformation(), Math.min(restrictions.getSendMaximum(), connAckRestrictions.getReceiveMaximum()), Math.min(restrictions.getSendMaximumPacketSize(), connAckRestrictions.getMaximumPacketSize()), Math.min(restrictions.getSendTopicAliasMaximum(), connAckRestrictions.getTopicAliasMaximum()), connAckRestrictions.getMaximumQos(), connAckRestrictions.isRetainAvailable(), connAckRestrictions.isWildcardSubscriptionAvailable(), connAckRestrictions.isSharedSubscriptionAvailable(), connAckRestrictions.areSubscriptionIdentifiersAvailable(), channel);
        this.clientConfig.setConnectionConfig(connectionConfig);
        return connectionConfig;
    }

    @Override
    protected void onDisconnectEvent(@NotNull MqttDisconnectEvent disconnectEvent) {
        super.onDisconnectEvent(disconnectEvent);
        this.connAckFlow.onError(disconnectEvent.getCause());
    }

    @Override
    protected long getTimeout() {
        return 60L;
    }

    @Override
    @NotNull
    protected Mqtt5DisconnectReasonCode getTimeoutReasonCode() {
        return Mqtt5DisconnectReasonCode.PROTOCOL_ERROR;
    }

    @Override
    @NotNull
    protected String getTimeoutReasonString() {
        return "Timeout while waiting for CONNACK";
    }
}

