/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.disconnect;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectHandler;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.internal.rx.CompletableFlow;
import com.hivemq.shaded.io.netty.channel.Channel;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;

public class MqttDisconnectCompletable
extends Completable {
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttDisconnect disconnect;

    public MqttDisconnectCompletable(@NotNull MqttClientConfig clientConfig, @NotNull MqttDisconnect disconnect) {
        this.clientConfig = clientConfig;
        this.disconnect = disconnect;
    }

    protected void subscribeActual(@NotNull CompletableObserver s) {
        MqttClientConnectionConfig connectionConfig = this.clientConfig.getRawConnectionConfig();
        if (connectionConfig == null) {
            EmptyDisposable.error((Throwable)MqttClientStateExceptions.notConnected(), (CompletableObserver)s);
            return;
        }
        Channel channel = connectionConfig.getChannel();
        MqttDisconnectHandler disconnectHandler = (MqttDisconnectHandler)channel.pipeline().get("disconnect");
        if (disconnectHandler == null) {
            EmptyDisposable.error((Throwable)MqttClientStateExceptions.notConnected(), (CompletableObserver)s);
            return;
        }
        CompletableFlow flow = new CompletableFlow(s);
        s.onSubscribe((Disposable)flow);
        disconnectHandler.disconnect(this.disconnect, flow);
    }
}

