/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.disconnect;

import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.internal.rx.CompletableFlow;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5DisconnectException;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;

public class MqttDisconnectEvent {
    @NotNull
    private final Throwable cause;
    private final boolean fromClient;

    MqttDisconnectEvent(@NotNull Throwable cause, boolean fromClient) {
        this.cause = cause;
        this.fromClient = fromClient;
    }

    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    boolean fromClient() {
        return this.fromClient;
    }

    @Nullable
    MqttDisconnect getDisconnect() {
        Mqtt5Disconnect mqttMessage;
        if (this.cause instanceof Mqtt5DisconnectException && (mqttMessage = ((Mqtt5DisconnectException)this.cause).getMqttMessage()) instanceof MqttDisconnect) {
            return (MqttDisconnect)mqttMessage;
        }
        return null;
    }

    static class ByUser
    extends MqttDisconnectEvent {
        @NotNull
        private final CompletableFlow flow;

        ByUser(@NotNull MqttDisconnect disconnect, @NotNull CompletableFlow flow) {
            super(new Mqtt5DisconnectException((Mqtt5Disconnect)disconnect, "Client sent DISCONNECT"), true);
            this.flow = flow;
        }

        @NotNull
        public CompletableFlow getFlow() {
            return this.flow;
        }
    }
}

