/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.disconnect;

import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.MqttConnectionAwareHandler;
import com.hivemq.client.internal.mqtt.handler.MqttSession;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectEvent;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.internal.rx.CompletableFlow;
import com.hivemq.client.mqtt.MqttClientState;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.exceptions.ConnectionClosedException;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5DisconnectException;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;
import com.hivemq.shaded.io.netty.channel.ChannelFuture;
import com.hivemq.shaded.io.netty.channel.ChannelFutureListener;
import com.hivemq.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.shaded.io.netty.util.concurrent.Future;
import com.hivemq.shaded.io.netty.util.concurrent.GenericFutureListener;
import com.hivemq.shaded.javax.inject.Inject;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;

@ConnectionScope
public class MqttDisconnectHandler
extends MqttConnectionAwareHandler {
    @NotNull
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(MqttDisconnectHandler.class);
    @NotNull
    public static final String NAME = "disconnect";
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttSession session;
    private boolean once = true;

    @Inject
    MqttDisconnectHandler(@NotNull MqttClientConfig clientConfig, @NotNull MqttSession session) {
        this.clientConfig = clientConfig;
        this.session = session;
    }

    @Override
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) throws Exception {
        if (msg instanceof MqttDisconnect) {
            this.readDisconnect(ctx, (MqttDisconnect)msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    private void readDisconnect(@NotNull ChannelHandlerContext ctx, @NotNull MqttDisconnect disconnect) {
        if (this.once) {
            this.once = false;
            MqttDisconnectUtil.fireDisconnectEvent(ctx.channel(), new Mqtt5DisconnectException((Mqtt5Disconnect)disconnect, "Server sent DISCONNECT."), false);
        }
    }

    @Override
    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        ctx.fireChannelInactive();
        if (this.once) {
            this.once = false;
            MqttDisconnectUtil.fireDisconnectEvent(ctx.channel(), new ConnectionClosedException("Server closed connection without DISCONNECT."), false);
        }
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        if (this.once) {
            this.once = false;
            MqttDisconnectUtil.fireDisconnectEvent(ctx.channel(), new ConnectionClosedException(cause), false);
        } else {
            LOGGER.error("Exception while disconnecting.", cause);
        }
    }

    public void disconnect(@NotNull MqttDisconnect disconnect, @NotNull CompletableFlow flow) {
        if (!this.clientConfig.executeInEventLoop(() -> this.writeDisconnect(disconnect, flow))) {
            flow.onError(MqttClientStateExceptions.notConnected());
        }
    }

    private void writeDisconnect(@NotNull MqttDisconnect disconnect, @NotNull CompletableFlow flow) {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx != null && this.once) {
            this.once = false;
            MqttDisconnectUtil.fireDisconnectEvent(ctx.channel(), new MqttDisconnectEvent.ByUser(disconnect, flow));
        } else {
            flow.onError(MqttClientStateExceptions.notConnected());
        }
    }

    @Override
    protected void onDisconnectEvent(@NotNull MqttDisconnectEvent disconnectEvent) {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            return;
        }
        super.onDisconnectEvent(disconnectEvent);
        this.once = false;
        this.session.expire(disconnectEvent.getCause(), ctx.channel().eventLoop());
        this.clientConfig.setConnectionConfig(null);
        this.clientConfig.getRawState().set(MqttClientState.DISCONNECTED);
        if (disconnectEvent.fromClient()) {
            MqttDisconnect disconnect = disconnectEvent.getDisconnect();
            if (disconnect != null) {
                if (disconnectEvent instanceof MqttDisconnectEvent.ByUser) {
                    CompletableFlow flow = ((MqttDisconnectEvent.ByUser)disconnectEvent).getFlow();
                    ctx.writeAndFlush(disconnect).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<ChannelFuture>)future -> {
                        future.channel().close();
                        if (future.isSuccess()) {
                            flow.onComplete();
                        } else {
                            flow.onError(new ConnectionClosedException(future.cause()));
                        }
                    }));
                } else if (this.clientConfig.getMqttVersion() == MqttVersion.MQTT_5_0) {
                    ctx.writeAndFlush(disconnect).addListener(ChannelFutureListener.CLOSE);
                } else {
                    ctx.channel().close();
                }
            } else {
                ctx.channel().close();
            }
        } else {
            ctx.channel().close();
        }
    }

    @Override
    public void channelUnregistered(@NotNull ChannelHandlerContext ctx) {
        ctx.fireChannelUnregistered();
        this.clientConfig.releaseEventLoop();
    }

    @Override
    public boolean isSharable() {
        return false;
    }
}

