/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.disconnect;

import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectEvent;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnectBuilder;
import com.hivemq.client.mqtt.exceptions.ConnectionClosedException;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5DisconnectException;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import com.hivemq.shaded.io.netty.channel.Channel;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;

public final class MqttDisconnectUtil {
    public static void close(@NotNull Channel channel, @NotNull Throwable cause) {
        MqttDisconnectUtil.fireDisconnectEvent(channel, cause, true);
    }

    public static void close(@NotNull Channel channel, @NotNull String reason) {
        MqttDisconnectUtil.fireDisconnectEvent(channel, new ConnectionClosedException(reason), true);
    }

    public static void disconnect(@NotNull Channel channel, @NotNull Mqtt5DisconnectReasonCode reasonCode, @NotNull String reasonString) {
        Mqtt5Disconnect disconnect = ((MqttDisconnectBuilder.Default)((MqttDisconnectBuilder.Default)new MqttDisconnectBuilder.Default().reasonCode(reasonCode)).reasonString(reasonString)).build();
        MqttDisconnectUtil.fireDisconnectEvent(channel, new Mqtt5DisconnectException(disconnect, reasonString), true);
    }

    public static void disconnect(@NotNull Channel channel, @NotNull Mqtt5DisconnectReasonCode reasonCode, @NotNull Throwable cause) {
        Mqtt5Disconnect disconnect = ((MqttDisconnectBuilder.Default)((MqttDisconnectBuilder.Default)new MqttDisconnectBuilder.Default().reasonCode(reasonCode)).reasonString(cause.getMessage())).build();
        MqttDisconnectUtil.fireDisconnectEvent(channel, new Mqtt5DisconnectException(disconnect, cause), true);
    }

    static void fireDisconnectEvent(@NotNull Channel channel, @NotNull Throwable cause, boolean fromClient) {
        MqttDisconnectUtil.fireDisconnectEvent(channel, new MqttDisconnectEvent(cause, fromClient));
    }

    static void fireDisconnectEvent(@NotNull Channel channel, @NotNull MqttDisconnectEvent disconnectEvent) {
        channel.config().setAutoRead(false);
        channel.pipeline().fireUserEventTriggered(disconnectEvent);
    }

    private MqttDisconnectUtil() {
    }
}

