/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.ping;

import com.hivemq.client.internal.mqtt.handler.MqttConnectionAwareHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectEvent;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.ping.MqttPingReq;
import com.hivemq.client.internal.mqtt.message.ping.MqttPingResp;
import com.hivemq.client.internal.util.netty.DefaultChannelOutboundHandler;
import com.hivemq.shaded.io.netty.channel.ChannelFuture;
import com.hivemq.shaded.io.netty.channel.ChannelFutureListener;
import com.hivemq.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.shaded.io.netty.util.concurrent.ScheduledFuture;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.concurrent.TimeUnit;

@ConnectionScope
public class MqttPingHandler
extends MqttConnectionAwareHandler
implements DefaultChannelOutboundHandler,
Runnable,
ChannelFutureListener {
    @NotNull
    public static final String NAME = "ping";
    private static final boolean PINGRESP_REQUIRED = false;
    private final long keepAliveNanos;
    private long lastFlushTimeNanos;
    private boolean pingReqWritten;
    private boolean pingReqFlushed;
    private boolean messageRead;
    @Nullable
    private ScheduledFuture<?> timeoutFuture;

    public MqttPingHandler(int keepAlive) {
        this.keepAliveNanos = TimeUnit.SECONDS.toNanos(keepAlive) - TimeUnit.MILLISECONDS.toNanos(100L);
    }

    @Override
    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        this.lastFlushTimeNanos = System.nanoTime();
        this.schedule(ctx, this.keepAliveNanos);
    }

    @Override
    public void flush(@NotNull ChannelHandlerContext ctx) {
        this.lastFlushTimeNanos = System.nanoTime();
        ctx.flush();
    }

    @Override
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof MqttPingResp) {
            this.messageRead = true;
        } else {
            this.messageRead = true;
            ctx.fireChannelRead(msg);
        }
    }

    private void schedule(@NotNull ChannelHandlerContext ctx, long delayNanos) {
        this.timeoutFuture = ctx.executor().schedule(this, delayNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public void run() {
        if (this.ctx == null) {
            return;
        }
        if (this.pingReqWritten) {
            if (!this.pingReqFlushed) {
                MqttDisconnectUtil.close(this.ctx.channel(), "Timeout while writing PINGREQ");
                return;
            }
            if (!this.messageRead) {
                MqttDisconnectUtil.close(this.ctx.channel(), "Timeout while waiting for PINGRESP");
                return;
            }
        }
        this.pingReqFlushed = false;
        this.messageRead = false;
        long nextDelayNanos = this.keepAliveNanos - (System.nanoTime() - this.lastFlushTimeNanos);
        if (nextDelayNanos > 1000L) {
            this.pingReqWritten = false;
            this.schedule(this.ctx, nextDelayNanos);
        } else {
            this.pingReqWritten = true;
            this.schedule(this.ctx, this.keepAliveNanos);
            this.ctx.writeAndFlush(MqttPingReq.INSTANCE).addListener(this);
        }
    }

    @Override
    public void operationComplete(@NotNull ChannelFuture future) {
        if (future.isSuccess()) {
            this.pingReqFlushed = true;
        }
    }

    @Override
    protected void onDisconnectEvent(@NotNull MqttDisconnectEvent disconnectEvent) {
        super.onDisconnectEvent(disconnectEvent);
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
        }
    }
}

