/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingQosHandler;
import com.hivemq.client.internal.mqtt.handler.subscribe.MqttSubscriptionFlow;
import com.hivemq.client.internal.mqtt.message.subscribe.suback.MqttSubAck;
import com.hivemq.client.internal.util.collections.HandleList;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.rx.FlowableWithSingleSubscriber;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import org.reactivestreams.Subscriber;

public class MqttSubscribedPublishFlow
extends MqttIncomingPublishFlow
implements MqttSubscriptionFlow<MqttSubAck> {
    @NotNull
    private final HandleList<MqttTopicFilterImpl> topicFilters = new HandleList();
    private int subscriptionIdentifier = -1;

    MqttSubscribedPublishFlow(@NotNull Subscriber<? super Mqtt5Publish> subscriber, @NotNull MqttClientConfig clientConfig, @NotNull MqttIncomingQosHandler incomingQosHandler) {
        super(subscriber, clientConfig, incomingQosHandler);
    }

    @Override
    public void onSuccess(@NotNull MqttSubAck subAck) {
        if (this.subscriber instanceof FlowableWithSingleSubscriber) {
            ((FlowableWithSingleSubscriber)this.subscriber).onSingle(subAck);
        }
    }

    @Override
    void runCancel() {
        this.incomingQosHandler.getIncomingPublishFlows().cancel(this);
        super.runCancel();
    }

    @NotNull
    HandleList<MqttTopicFilterImpl> getTopicFilters() {
        return this.topicFilters;
    }

    int getSubscriptionIdentifier() {
        return this.subscriptionIdentifier;
    }

    void setSubscriptionIdentifier(int subscriptionIdentifier) {
        this.subscriptionIdentifier = subscriptionIdentifier;
    }
}

