/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscribedPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscriptionFlows;
import com.hivemq.client.internal.util.collections.HandleList;
import com.hivemq.shaded.javax.inject.Inject;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;

@NotThreadSafe
public class MqttSubscriptionFlowList
implements MqttSubscriptionFlows {
    @NotNull
    private final HandleList<MqttSubscribedPublishFlow> flows = new HandleList();
    @NotNull
    private final HashMap<MqttTopicFilterImpl, Integer> subscribedTopicFilters = new HashMap();

    @Inject
    MqttSubscriptionFlowList() {
    }

    @Override
    public void subscribe(@NotNull MqttTopicFilterImpl topicFilter, @Nullable MqttSubscribedPublishFlow flow) {
        Integer count;
        if (flow != null) {
            HandleList<MqttTopicFilterImpl> topicFilters = flow.getTopicFilters();
            if (topicFilters.isEmpty()) {
                this.flows.add(flow);
            }
            topicFilters.add(topicFilter);
        }
        if ((count = this.subscribedTopicFilters.put(topicFilter, 1)) != null) {
            this.subscribedTopicFilters.put(topicFilter, count + 1);
        }
    }

    @Override
    public void remove(@NotNull MqttTopicFilterImpl topicFilter, @Nullable MqttSubscribedPublishFlow flow) {
        Integer count;
        if (flow != null) {
            HandleList<MqttTopicFilterImpl> topicFilters = flow.getTopicFilters();
            Iterator<Object> iterator = topicFilters.iterator();
            while (iterator.hasNext()) {
                if (!topicFilter.equals(iterator.next())) continue;
                iterator.remove();
                break;
            }
            if (topicFilters.isEmpty()) {
                iterator = this.flows.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != flow) continue;
                    iterator.remove();
                    break;
                }
            }
        }
        if ((count = this.subscribedTopicFilters.remove(topicFilter)) != null && count > 1) {
            this.subscribedTopicFilters.put(topicFilter, count - 1);
        }
    }

    @Override
    public void unsubscribe(@NotNull MqttTopicFilterImpl topicFilter, @Nullable Consumer<MqttSubscribedPublishFlow> unsubscribedCallback) {
        Iterator<MqttSubscribedPublishFlow> flowIt = this.flows.iterator();
        while (flowIt.hasNext()) {
            MqttSubscribedPublishFlow flow = flowIt.next();
            HandleList<MqttTopicFilterImpl> flowTopicFilters = flow.getTopicFilters();
            Iterator<MqttTopicFilterImpl> iterator = flowTopicFilters.iterator();
            while (iterator.hasNext()) {
                if (!topicFilter.equals(iterator.next())) continue;
                iterator.remove();
            }
            if (!flowTopicFilters.isEmpty()) continue;
            flowIt.remove();
            flow.onComplete();
            if (unsubscribedCallback == null) continue;
            unsubscribedCallback.accept(flow);
        }
        this.subscribedTopicFilters.remove(topicFilter);
    }

    @Override
    public void cancel(@NotNull MqttSubscribedPublishFlow flow) {
        Iterator<MqttSubscribedPublishFlow> iterator = this.flows.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != flow) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public boolean findMatching(@NotNull MqttTopicImpl topic, @NotNull HandleList<MqttIncomingPublishFlow> matchingFlows) {
        block0: for (MqttSubscribedPublishFlow flow : this.flows) {
            for (MqttTopicFilterImpl topicFilter : flow.getTopicFilters()) {
                if (!topicFilter.matches(topic)) continue;
                matchingFlows.add(flow);
                continue block0;
            }
        }
        if (!matchingFlows.isEmpty()) {
            return true;
        }
        for (MqttTopicFilterImpl subscribedTopicFilter : this.subscribedTopicFilters.keySet()) {
            if (!subscribedTopicFilter.matches(topic)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear(@NotNull Throwable cause) {
        Iterator<MqttSubscribedPublishFlow> iterator = this.flows.iterator();
        while (iterator.hasNext()) {
            iterator.next().onError(cause);
            iterator.remove();
        }
        this.subscribedTopicFilters.clear();
    }
}

