/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.outgoing;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttIncomingAckFlow;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttOutgoingQosHandler;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttPublishFlowableAckLink;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttPublishFlowables;
import com.hivemq.client.internal.mqtt.ioc.ClientComponent;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import io.reactivex.Flowable;
import io.reactivex.internal.subscriptions.EmptySubscription;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MqttIncomingAckFlowable
extends Flowable<Mqtt5PublishResult> {
    @NotNull
    private final Flowable<MqttPublish> publishFlowable;
    @NotNull
    private final MqttClientConfig clientConfig;

    public MqttIncomingAckFlowable(@NotNull Flowable<MqttPublish> publishFlowable, @NotNull MqttClientConfig clientConfig) {
        this.publishFlowable = publishFlowable;
        this.clientConfig = clientConfig;
    }

    protected void subscribeActual(@NotNull Subscriber<? super Mqtt5PublishResult> subscriber) {
        if (this.clientConfig.getState().isConnectedOrReconnect()) {
            ClientComponent clientComponent = this.clientConfig.getClientComponent();
            MqttOutgoingQosHandler outgoingQosHandler = clientComponent.outgoingQosHandler();
            MqttPublishFlowables publishFlowables = outgoingQosHandler.getPublishFlowables();
            MqttIncomingAckFlow flow = new MqttIncomingAckFlow(subscriber, this.clientConfig, outgoingQosHandler);
            subscriber.onSubscribe((Subscription)flow);
            publishFlowables.add(new MqttPublishFlowableAckLink(this.publishFlowable, flow));
        } else {
            EmptySubscription.error((Throwable)MqttClientStateExceptions.notConnected(), subscriber);
        }
    }
}

