/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.outgoing;

import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttPublishWithFlow;
import com.hivemq.client.internal.mqtt.ioc.ClientScope;
import com.hivemq.shaded.javax.inject.Inject;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import io.reactivex.Flowable;
import io.reactivex.internal.util.BackpressureHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@ClientScope
public class MqttPublishFlowables
extends Flowable<Flowable<MqttPublishWithFlow>>
implements Subscription {
    @NotNull
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(MqttPublishFlowables.class);
    @Nullable
    private Subscriber<? super Flowable<MqttPublishWithFlow>> subscriber;
    private long requested;

    @Inject
    MqttPublishFlowables() {
    }

    protected void subscribeActual(@NotNull Subscriber<? super Flowable<MqttPublishWithFlow>> s) {
        assert (this.subscriber == null);
        this.subscriber = s;
        s.onSubscribe((Subscription)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull Flowable<MqttPublishWithFlow> publishFlowable) {
        MqttPublishFlowables mqttPublishFlowables = this;
        synchronized (mqttPublishFlowables) {
            while (this.requested == 0L) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {
                    LOGGER.error("thread interrupted while waiting to publish.", e);
                    return;
                }
            }
            assert (this.subscriber != null);
            this.subscriber.onNext(publishFlowable);
            --this.requested;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long n) {
        MqttPublishFlowables mqttPublishFlowables = this;
        synchronized (mqttPublishFlowables) {
            this.requested = BackpressureHelper.addCap((long)this.requested, (long)n);
            if (this.requested == n) {
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    public void cancel() {
        this.subscriber = null;
    }
}

