/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.ssl;

import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.shaded.io.netty.channel.Channel;
import com.hivemq.shaded.io.netty.channel.ChannelHandler;
import com.hivemq.shaded.io.netty.handler.ssl.SslContext;
import com.hivemq.shaded.io.netty.handler.ssl.SslContextBuilder;
import com.hivemq.shaded.io.netty.handler.ssl.SslHandler;
import com.hivemq.shaded.io.netty.handler.ssl.SslProvider;
import com.hivemq.shaded.io.netty.handler.ssl.SupportedCipherSuiteFilter;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public final class SslUtil {
    @NotNull
    private static final String SSL_HANDLER_NAME = "ssl";

    public static void initChannel(@NotNull Channel channel, @NotNull MqttClientSslConfigImpl sslConfig) throws SSLException {
        channel.pipeline().addFirst(SSL_HANDLER_NAME, (ChannelHandler)SslUtil.createSslHandler(channel, sslConfig));
    }

    @NotNull
    private static SslHandler createSslHandler(@NotNull Channel channel, @NotNull MqttClientSslConfigImpl sslConfig) throws SSLException {
        SSLEngine sslEngine = SslUtil.createSslEngine(channel, sslConfig);
        SslHandler sslHandler = new SslHandler(sslEngine);
        sslHandler.setHandshakeTimeoutMillis(sslConfig.getHandshakeTimeoutMs());
        return sslHandler;
    }

    @NotNull
    static SSLEngine createSslEngine(@NotNull Channel channel, @NotNull MqttClientSslConfigImpl sslConfig) throws SSLException {
        SSLEngine sslEngine = SslUtil.createSslContext(sslConfig).newEngine(channel.alloc());
        sslEngine.setUseClientMode(true);
        return sslEngine;
    }

    @NotNull
    private static SslContext createSslContext(@NotNull MqttClientSslConfigImpl sslConfig) throws SSLException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(sslConfig.getRawTrustManagerFactory()).keyManager(sslConfig.getRawKeyManagerFactory());
        ImmutableList<String> protocols = sslConfig.getRawProtocols();
        String[] protocolArray = protocols == null ? null : protocols.toArray(new String[protocols.size()]);
        sslContextBuilder.protocols(protocolArray);
        sslContextBuilder.ciphers(sslConfig.getRawCipherSuites(), SupportedCipherSuiteFilter.INSTANCE);
        return sslContextBuilder.build();
    }

    private SslUtil() {
    }
}

