/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.util;

import com.hivemq.client.internal.annotations.CallByThread;
import com.hivemq.client.internal.mqtt.handler.MqttConnectionAwareHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectEvent;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import com.hivemq.shaded.io.netty.channel.Channel;
import com.hivemq.shaded.io.netty.channel.ChannelFuture;
import com.hivemq.shaded.io.netty.channel.ChannelFutureListener;
import com.hivemq.shaded.io.netty.util.concurrent.ScheduledFuture;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.concurrent.TimeUnit;

public abstract class MqttTimeoutInboundHandler
extends MqttConnectionAwareHandler
implements Runnable,
ChannelFutureListener {
    @Nullable
    private ScheduledFuture<?> timeoutFuture;

    @Override
    public void operationComplete(@NotNull ChannelFuture future) {
        if (this.ctx == null) {
            return;
        }
        if (future.isSuccess()) {
            this.scheduleTimeout(this.ctx.channel());
        }
    }

    @Override
    @CallByThread(value="Netty EventLoop")
    public void run() {
        if (this.ctx == null) {
            return;
        }
        Channel channel = this.ctx.channel();
        if (channel.isActive()) {
            MqttDisconnectUtil.disconnect(channel, this.getTimeoutReasonCode(), this.getTimeoutReasonString());
        } else {
            MqttDisconnectUtil.close(channel, this.getTimeoutReasonString());
        }
    }

    @CallByThread(value="Netty EventLoop")
    protected void scheduleTimeout(@NotNull Channel channel) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
            this.run();
        } else {
            this.timeoutFuture = channel.eventLoop().schedule(this, this.getTimeout(), TimeUnit.SECONDS);
        }
    }

    @CallByThread(value="Netty EventLoop")
    protected void cancelTimeout() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
        }
    }

    @Override
    protected void onDisconnectEvent(@NotNull MqttDisconnectEvent disconnectEvent) {
        super.onDisconnectEvent(disconnectEvent);
        this.cancelTimeout();
    }

    protected abstract long getTimeout();

    @NotNull
    protected abstract Mqtt5DisconnectReasonCode getTimeoutReasonCode();

    @NotNull
    protected abstract String getTimeoutReasonString();

    @Override
    public final boolean isSharable() {
        return false;
    }
}

