/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.websocket;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.handler.MqttChannelInitializer;
import com.hivemq.client.internal.mqtt.handler.websocket.WebSocketBinaryFrameDecoder;
import com.hivemq.client.internal.mqtt.handler.websocket.WebSocketBinaryFrameEncoder;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.mqtt.MqttWebSocketConfig;
import com.hivemq.shaded.io.netty.channel.Channel;
import com.hivemq.shaded.io.netty.channel.ChannelHandler;
import com.hivemq.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import com.hivemq.shaded.io.netty.handler.codec.http.HttpClientCodec;
import com.hivemq.shaded.io.netty.handler.codec.http.HttpObjectAggregator;
import com.hivemq.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import com.hivemq.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.hivemq.shaded.javax.inject.Inject;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import java.net.URI;
import java.net.URISyntaxException;

@ConnectionScope
public class MqttWebSocketInitializer
extends ChannelInboundHandlerAdapter {
    @NotNull
    private static final String NAME = "ws.init";
    @NotNull
    private static final String PROTOCOL_HANDLER_NAME = "ws.protocol";
    @NotNull
    private static final String HTTP_CODEC_NAME = "http.codec";
    @NotNull
    private static final String HTTP_AGGREGATOR_NAME = "http.aggregator";
    @NotNull
    private static final String WEBSOCKET_URI_SCHEME = "ws";
    @NotNull
    private static final String WEBSOCKET_TLS_URI_SCHEME = "wss";
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttChannelInitializer mqttChannelInitializer;
    @NotNull
    private final WebSocketBinaryFrameEncoder webSocketBinaryFrameEncoder;
    @NotNull
    private final WebSocketBinaryFrameDecoder webSocketBinaryFrameDecoder;

    @Inject
    MqttWebSocketInitializer(@NotNull MqttClientConfig clientConfig, @NotNull MqttChannelInitializer mqttChannelInitializer, @NotNull WebSocketBinaryFrameEncoder webSocketBinaryFrameEncoder, @NotNull WebSocketBinaryFrameDecoder webSocketBinaryFrameDecoder) {
        this.clientConfig = clientConfig;
        this.mqttChannelInitializer = mqttChannelInitializer;
        this.webSocketBinaryFrameEncoder = webSocketBinaryFrameEncoder;
        this.webSocketBinaryFrameDecoder = webSocketBinaryFrameDecoder;
    }

    public void initChannel(@NotNull Channel channel, @NotNull MqttWebSocketConfig webSocketConfig) throws URISyntaxException {
        HttpClientCodec httpCodec = new HttpClientCodec();
        HttpObjectAggregator httpAggregator = new HttpObjectAggregator(0x10000004);
        URI uri = new URI(this.clientConfig.getRawSslConfig() == null ? WEBSOCKET_URI_SCHEME : WEBSOCKET_TLS_URI_SCHEME, null, this.clientConfig.getServerHost(), this.clientConfig.getServerPort(), "/" + webSocketConfig.getServerPath(), null, null);
        WebSocketClientProtocolHandler webSocketClientProtocolHandler = new WebSocketClientProtocolHandler(uri, WebSocketVersion.V13, webSocketConfig.getSubprotocol(), true, null, 0x10000004);
        channel.pipeline().addLast(HTTP_CODEC_NAME, (ChannelHandler)httpCodec).addLast(HTTP_AGGREGATOR_NAME, (ChannelHandler)httpAggregator).addLast(PROTOCOL_HANDLER_NAME, (ChannelHandler)webSocketClientProtocolHandler).addLast(NAME, (ChannelHandler)this).addLast("ws.encoder", (ChannelHandler)this.webSocketBinaryFrameEncoder).addLast("ws.decoder", (ChannelHandler)this.webSocketBinaryFrameDecoder);
    }

    @Override
    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
            this.mqttChannelInitializer.initMqtt(ctx.channel());
            ctx.pipeline().remove(this);
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        this.mqttChannelInitializer.exceptionCaught(ctx, cause);
    }

    @Override
    public boolean isSharable() {
        return false;
    }
}

