/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.ioc;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.handler.MqttChannelInitializer;
import com.hivemq.client.internal.mqtt.handler.auth.MqttAuthHandler;
import com.hivemq.client.internal.mqtt.handler.auth.MqttConnectAuthHandler;
import com.hivemq.client.internal.mqtt.handler.auth.MqttDisconnectOnAuthHandler;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.netty.NettyEventLoopProvider;
import com.hivemq.shaded.dagger.Lazy;
import com.hivemq.shaded.dagger.Module;
import com.hivemq.shaded.dagger.Provides;
import com.hivemq.shaded.io.netty.bootstrap.Bootstrap;
import com.hivemq.shaded.io.netty.buffer.ByteBufAllocator;
import com.hivemq.shaded.io.netty.channel.ChannelOption;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;

@Module
abstract class ConnectionModule {
    ConnectionModule() {
    }

    @Provides
    @NotNull
    static Bootstrap provideBootstrap(@NotNull MqttClientConfig clientConfig, @NotNull NettyEventLoopProvider nettyEventLoopProvider, @NotNull MqttChannelInitializer channelInitializer) {
        return (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(clientConfig.acquireEventLoop())).channelFactory(nettyEventLoopProvider.getChannelFactory())).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.ALLOCATOR, ByteBufAllocator.DEFAULT)).handler(channelInitializer);
    }

    @Provides
    @ConnectionScope
    @NotNull
    static MqttAuthHandler provideAuthHandler(@NotNull MqttConnect connect, @NotNull Lazy<MqttConnectAuthHandler> connectAuthHandlerLazy, @NotNull Lazy<MqttDisconnectOnAuthHandler> disconnectOnAuthHandlerLazy) {
        return connect.getRawEnhancedAuthMechanism() == null ? (MqttAuthHandler)disconnectOnAuthHandlerLazy.get() : (MqttAuthHandler)connectAuthHandlerLazy.get();
    }
}

